/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SqlBuilder {
    private Map<String, String> aliasToTable;
    private Set<String> columnAliases;
    private ICMDbStoreSqlGenerator sqlGenerator;
    private StringBuffer sql;

    public SqlBuilder(ICMDbStoreSqlGenerator sqlGenerator) {
        this.sqlGenerator = sqlGenerator;
        this.sql = new StringBuffer();
        this.aliasToTable = new HashMap<String, String>();
        this.columnAliases = new HashSet<String>();
    }

    public SqlBuilder aliasedColumn(String alias, String column) {
        this.columnAliases.add(alias);
        this.sqlGenerator.appendColumnWithAlias(column, alias, this.sql);
        return this;
    }

    public SqlBuilder column(String alias, String column) {
        return this.aliasedColumn(alias, column);
    }

    public SqlBuilder aliasedTable(String alias, String table) {
        String retrievedTable = this.aliasToTable.get(alias);
        if (retrievedTable == null) {
            this.aliasToTable.put(alias, table);
        } else if (!retrievedTable.equals(table)) {
            throw new RuntimeException("Alias '" + alias + "' has already been bound to table '" + retrievedTable + "'.");
        }
        this.sql.append(this.sqlGenerator.createTableWithAliasSql(table, alias));
        return this;
    }

    public SqlBuilder and() {
        this.sql.append(this.sqlGenerator.createAndSql());
        return this;
    }

    public SqlBuilder or() {
        this.sql.append(this.sqlGenerator.createOrSql());
        return this;
    }

    public SqlBuilder append(String string) {
        this.sql.append(string);
        return this;
    }

    public SqlBuilder as() {
        this.sql.append(this.sqlGenerator.createAsSql());
        return this;
    }

    public SqlBuilder caseEndAsBoolean() {
        this.sql.append(this.sqlGenerator.createEndCaseForBooleanSql());
        return this;
    }

    public SqlBuilder caseWhen() {
        this.sql.append(this.sqlGenerator.createStartCaseWhenSql());
        return this;
    }

    public SqlBuilder cast() {
        this.sql.append(this.sqlGenerator.createStartCastSql());
        return this;
    }

    public void clear() {
        this.sql = new StringBuffer();
        this.aliasToTable.clear();
        this.columnAliases.clear();
    }

    public SqlBuilder closeBracket() {
        this.sql.append(this.sqlGenerator.createClosingBracket());
        return this;
    }

    public SqlBuilder openBracket() {
        this.sql.append(this.sqlGenerator.createOpeningBracket());
        return this;
    }

    public SqlBuilder coalesce() {
        this.sql.append(this.sqlGenerator.createStartCoalesceSql());
        return this;
    }

    public SqlBuilder count() {
        this.sql.append(this.sqlGenerator.createCount());
        this.sql.append(this.sqlGenerator.createOpeningBracket());
        return this;
    }

    public SqlBuilder equalsBindParameter() {
        this.sql.append(this.sqlGenerator.createEqualsBindParameterSymbol());
        return this;
    }

    public SqlBuilder eq() {
        this.sql.append(this.sqlGenerator.createEqualsSql());
        return this;
    }

    public SqlBuilder ne() {
        this.sql.append(this.sqlGenerator.createNotEqualsSql());
        return this;
    }

    public SqlBuilder equalsValue(int value) {
        this.sql.append("=").append(value);
        return this;
    }

    public SqlBuilder from() {
        this.sql.append(this.sqlGenerator.createFromSql());
        return this;
    }

    public SqlBuilder from(String table_name, String alias) {
        this.sql.append(this.sqlGenerator.createFromSql());
        return this.aliasedTable(alias, table_name);
    }

    public StringBuffer getBuffer() {
        return this.sql;
    }

    public ICMDbStoreSqlGenerator getSqlGenerator() {
        return this.sqlGenerator;
    }

    public SqlBuilder greaterThan(int value) {
        this.sql.append(" > ").append(value).append(" ");
        return this;
    }

    public SqlBuilder groupBy() {
        this.sql.append(this.sqlGenerator.createGroupBy());
        return this;
    }

    public SqlBuilder in(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("Cannot create an empty in clause");
        }
        this.sql.append(this.sqlGenerator.createInSql()).append("(");
        for (int val : values) {
            this.sql.append(val).append(",");
        }
        this.sql.replace(this.sql.length() - 1, this.sql.length(), ")");
        return this;
    }

    public SqlBuilder innerJoin() {
        this.sql.append(this.sqlGenerator.createInnerJoin());
        return this;
    }

    public SqlBuilder innerJoin(String tableName, String alias) {
        this.sql.append(this.sqlGenerator.createInnerJoin());
        this.aliasedTable(alias, tableName);
        return this;
    }

    public SqlBuilder leftOuterJoin(String tableName, String alias) {
        this.sql.append(this.sqlGenerator.createLeftOuterJoinTableWithAliasSql(tableName, alias));
        return this;
    }

    public SqlBuilder length() {
        this.sql.append(CMDbStoreUtil.getLengthFunctionName());
        this.sql.append(this.sqlGenerator.createOpeningBracket());
        return this;
    }

    public SqlBuilder lobIsNotNull(String alias, String column) {
        if (CMDbConnection.dbms_ == 4) {
            this.sql.append(this.sqlGenerator.createIsNullExpression(alias + "." + column, false));
        } else {
            this.aliasedColumn(alias, column);
            this.sql.append(" is not null ");
        }
        return this;
    }

    public SqlBuilder lobIsNull(String alias, String column) {
        if (CMDbConnection.dbms_ == 4) {
            this.sql.append(this.sqlGenerator.createIsNullExpression(alias + "." + column, true));
        } else {
            this.aliasedColumn(alias, column);
            this.sql.append(this.sqlGenerator.createIsNullSql()).append(" ");
        }
        return this;
    }

    public SqlBuilder notEquals() {
        this.sql.append(" <> ");
        return this;
    }

    public SqlBuilder onJoinConditionEquals(String alias1, String column1, String alias2, String column2) {
        this.sqlGenerator.appendOnJoinColumns(column1, alias1, column2, alias2, this.sql);
        return this;
    }

    public SqlBuilder on() {
        this.sql.append(this.sqlGenerator.createOnSql());
        return this;
    }

    public SqlBuilder orderBy() {
        this.sql.append(this.sqlGenerator.createOrderBySql());
        return this;
    }

    public SqlBuilder plus() {
        this.sql.append(this.sqlGenerator.createPlusSql());
        return this;
    }

    public SqlBuilder select() {
        this.sql.append(this.sqlGenerator.createSelectSql());
        return this;
    }

    public SqlBuilder separator() {
        this.sql.append(this.sqlGenerator.createColumnsSeparator());
        return this;
    }

    public SqlBuilder sum() {
        this.sql.append(this.sqlGenerator.createStartSumSql());
        return this;
    }

    public String toString() {
        return this.sql.toString();
    }

    public SqlBuilder union() {
        this.sql.append(" union ");
        return this;
    }

    public void validate() {
        for (String columnAlias : this.columnAliases) {
            if (this.aliasToTable.containsKey(columnAlias)) continue;
            throw new RuntimeException("Alias '" + columnAlias + "' has not been bound to a table");
        }
    }

    public SqlBuilder where() {
        this.sql.append(this.sqlGenerator.createWhereSql());
        return this;
    }

    public SqlBuilder descending() {
        this.sql.append(this.sqlGenerator.createDescSql());
        return this;
    }
}

