/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMPreparedStatementBase;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.AllInOneCounter;
import com.cognos.cm.diagnostics.BroadcastCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.diagnostics.TopTenCounter;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.indications.CMSessionLogging;
import com.cognos.cm.server.CMException;
import com.cognos.perfMonitor.PerfCategory;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import java.io.InputStream;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class StatementProxy
extends CMPreparedStatementBase {
    private static final String CLOSE_STMT = "close";
    private static final PerfCategory PERF_TRACE_JDBC = PerfMonitor.getCategory((String)"TRACE!com.cognos.cm.JDBC.SQL", (String)"", (int)5);
    private static final PerfTimer PERF_IN_DBMS = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.function.inDBMS", (String)"The count and the time spent in DBMS", (int)5);
    public static final Counter inDB = new AccumulatingCounter().makeThreadLocal();
    public static final Counter topSQL = new TopTenCounter(10).makeThreadLocal();
    public static final Counter traceSQL = new AllInOneCounter().makeThreadLocal();
    private static final Timer timer = new Timer(new BroadcastCounter(inDB, topSQL, traceSQL));
    private String statementID_;
    private String connectionID_;
    private String statement_;
    private ArrayList<ParamInfo> params;
    private boolean ipfLogging;
    private boolean sessionLogging;
    private long executeDuration;
    private PerfTimer timerSQL;

    public StatementProxy(Statement ps, String statement) throws SQLException {
        super(ps);
        this.statement_ = statement;
        this.statementID_ = Integer.toString(System.identityHashCode(ps));
        this.connectionID_ = Integer.toString(System.identityHashCode(ps.getConnection()));
        this.reset();
    }

    public void reset() {
        this.sessionLogging = CMSessionLogging.isLoggingSQL();
        this.ipfLogging = CMIndicationGlobals.bDbConnection_TraceSQLStatements;
        this.params = null;
        if (this.sessionLogging || CMIndicationGlobals.bDbConnection_TraceSQLParameters) {
            this.params = new ArrayList();
        }
    }

    private void startExecute() {
        if (this.sessionLogging) {
            CMSessionLogging.logSQLStart(this.statement_, this.getParametersForLogs(), this.connectionID_, this.statementID_);
            this.executeDuration = System.currentTimeMillis();
        }
        if (this.ipfLogging) {
            this.logExecute();
        }
        if (this.statement_ != CLOSE_STMT) {
            if (PERF_TRACE_JDBC.isEnabled()) {
                this.timerSQL = PerfMonitor.getTimer((String)(PERF_TRACE_JDBC.getName() + ".statement=" + this.statement_));
                this.timerSQL.start();
            }
            PERF_IN_DBMS.start();
            timer.start();
        }
    }

    private void endExecute() {
        if (this.statement_ != CLOSE_STMT) {
            timer.stop(this.statement_);
            PERF_IN_DBMS.stop();
            if (this.timerSQL != null) {
                this.timerSQL.stop();
            }
        }
        if (this.sessionLogging) {
            this.executeDuration = System.currentTimeMillis() - this.executeDuration;
            CMSessionLogging.logSQLFinish(this.executeDuration, this.connectionID_, this.statementID_);
        }
    }

    private void logExecute() {
        String sStmt = this.statement_;
        String p = this.getParametersForLogs();
        if (p != null) {
            sStmt = sStmt + p;
        }
        CMIndications.CMTrace("cmSQLExecute", new CMException.Parm[]{new CMException.Parm("SQL", sStmt), new CMException.Parm("ConID", this.connectionID_), new CMException.Parm("StmtID", this.statementID_)});
    }

    private String getParametersForLogs() {
        if (null == this.params || this.params.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (ParamInfo pi : this.params) {
            sb.append("<SQLParm index=\"");
            sb.append(pi.index);
            sb.append("\" type=\"");
            sb.append(pi.type.name());
            sb.append("\"><![CDATA[");
            if (null != pi.value && 1024 < pi.value.length()) {
                sb.append(pi.value.substring(0, 1023));
                sb.append("...[");
                sb.append(pi.value.length() - 1023);
                sb.append(" characters truncated]");
            } else {
                sb.append(pi.value);
            }
            sb.append("]]></SQLParm>");
        }
        return sb.toString();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.statement_ = this.statement_ == null ? sql : this.statement_ + "; " + sql;
        super.addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.statement_ = null;
        if (this.params != null) {
            this.params.clear();
        }
        super.clearBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.params != null) {
            this.params.clear();
        }
        super.clearParameters();
    }

    @Override
    public void close() throws SQLException {
        this.statement_ = CLOSE_STMT;
        this.params = null;
        this.startExecute();
        try {
            super.close();
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.startExecute();
        try {
            boolean bl = super.execute();
            return bl;
        }
        finally {
            this.endExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            boolean bl = super.execute(sql, autoGeneratedKeys);
            return bl;
        }
        finally {
            this.endExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            boolean bl = super.execute(sql, columnIndexes);
            return bl;
        }
        finally {
            this.endExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            boolean bl = super.execute(sql, columnNames);
            return bl;
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            boolean bl = super.execute(sql);
            return bl;
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.startExecute();
        try {
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.startExecute();
        try {
            ResultSet resultSet = super.executeQuery();
            return resultSet;
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            ResultSet resultSet = super.executeQuery(sql);
            return resultSet;
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.startExecute();
        try {
            int n = super.executeUpdate();
            return n;
        }
        finally {
            this.endExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            int n = super.executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        finally {
            this.endExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            int n = super.executeUpdate(sql, columnIndexes);
            return n;
        }
        finally {
            this.endExecute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            int n = super.executeUpdate(sql, columnNames);
            return n;
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.statement_ = sql;
        this.startExecute();
        try {
            int n = super.executeUpdate(sql);
            return n;
        }
        finally {
            this.endExecute();
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.BINARY_STREAM, Integer.toString(length)));
        }
        super.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.BINARY_STREAM, x.toString()));
        }
        super.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.BINARY_STREAM, Long.toString(length)));
        }
        super.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.BOOLEAN, Boolean.toString(x)));
        }
        super.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.BYTE, Byte.toString(x)));
        }
        super.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.BYTES, x == null ? "null" : Integer.toString(x.length)));
        }
        super.setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.CHARACTER_STREAM, Integer.toString(length)));
        }
        super.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.CHARACTER_STREAM, reader.toString()));
        }
        super.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.CHARACTER_STREAM, Long.toString(length)));
        }
        super.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.DOUBLE, Double.toString(x)));
        }
        super.setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.FLOAT, Float.toString(x)));
        }
        super.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.INT, Integer.toString(x)));
        }
        super.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.LONG, Long.toString(x)));
        }
        super.setLong(parameterIndex, x);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(paramIndex, Type.NULL, "null"));
        }
        super.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.NULL, "null"));
        }
        super.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.OBJECT, x == null ? "null" : x.toString()));
        }
        super.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.OBJECT, x == null ? "null" : x.toString()));
        }
        super.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.OBJECT, x == null ? "null" : x.toString()));
        }
        super.setObject(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.SHORT, Short.toString(x)));
        }
        super.setShort(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.STRING, x));
        }
        super.setString(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.TIMESTAMP, x.toString()));
        }
        super.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (this.params != null) {
            this.params.add(new ParamInfo(parameterIndex, Type.TIMESTAMP, x.toString()));
        }
        super.setTimestamp(parameterIndex, x);
    }

    private static class ParamInfo {
        public int index;
        public Type type;
        public String value;

        public ParamInfo(int n, Type t, String v) {
            this.index = n;
            this.type = t;
            this.value = v;
        }
    }

    private static enum Type {
        UNKNOWN,
        NULL,
        OBJECT,
        BINARY_STREAM,
        BOOLEAN,
        BYTE,
        BYTES,
        CHARACTER_STREAM,
        DOUBLE,
        FLOAT,
        INT,
        LONG,
        SHORT,
        STRING,
        TIMESTAMP;

    }
}

