/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbObjectClass;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreDelCacheObjects;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStorePrepStmtCache;
import com.cognos.cm.dbstore.CMDbStoreTransactionAction;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreDuplicateObject;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStoreXPath;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;

public class StubFolder {
    private static int stubFolderId_ = -1;
    private static Object stubFolderMutex_ = new Object();

    public static void addObjects(CMStore cmStore, int[] objectIDs) throws CMException {
        CMDbStore store = (CMDbStore)cmStore;
        int pid = StubFolder.getStubFolderID(store);
        for (int i = 0; i < objectIDs.length; ++i) {
            CMDbStoreString name = new CMDbStoreString(String.valueOf(objectIDs[i]));
            try {
                CMStoreQueryResults results = store.createObject(pid, objectIDs[i], name, CMObjectClass._DELETEDOBJECT, null, null, false);
                results.release();
                continue;
            }
            catch (CMStoreDuplicateObject cMStoreDuplicateObject) {
                // empty catch block
            }
        }
        store.addTransactionAction(new CreateStubsTA(store, objectIDs));
    }

    public static void deleteObjects(CMStore cmStore, int[] objectIDs) throws CMException {
        if (objectIDs == null) {
            return;
        }
        CMDbStore store = (CMDbStore)cmStore;
        CMDbConnection con = store.getConnection();
        try {
            String[] delQueries = CMDbStorePrepStmtCache.deletePropsStmts_;
            BitSet tableMask = ((CMDbObjectClass)CMObjectClass._DELETEDOBJECT).getTableMask();
            CMDbStoreUtil.deleteFromTables(con, delQueries, tableMask, objectIDs, null, null, false);
            store.addTransactionAction(new CMDbStoreDelCacheObjects(store, objectIDs){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void commit() {
                    Object object = stubFolderMutex_;
                    synchronized (object) {
                        super.commit();
                    }
                }
            });
        }
        catch (SQLException ex) {
            CMDbStoreExceptionUtil.handleSQLException(con, ex, "cmStoreUnexpectedErrDeleteObjs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getStubFolderID(CMStore store) throws CMException {
        if (stubFolderId_ == -1) {
            Object object = stubFolderMutex_;
            synchronized (object) {
                if (stubFolderId_ == -1) {
                    CMStoreQueryResults results = null;
                    try {
                        CMStoreXPath path = new CMStoreXPath("/_deletedObjectFolder");
                        results = store.executeQuery(path, null, null, 0, 512, null);
                        if (!results.next()) {
                            throw new CMStoreUnexpected(null, "cmStoreUnexpectedCacheQuery");
                        }
                        stubFolderId_ = results.getObjectID();
                    }
                    finally {
                        if (results != null) {
                            results.release();
                        }
                    }
                }
            }
        }
        return stubFolderId_;
    }

    private static class CreateStubsTA
    implements CMDbStoreTransactionAction {
        CMDbStore store_;
        int[] objectIDs_;

        CreateStubsTA(CMDbStore store, int[] objectIDs) {
            this.store_ = store;
            this.objectIDs_ = objectIDs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            CMCache cache = this.store_.getCache();
            try {
                int parent_id = StubFolder.getStubFolderID(this.store_);
                Object object = stubFolderMutex_;
                synchronized (object) {
                    for (int i = 0; i < this.objectIDs_.length; ++i) {
                        cache.CMCacheUpdateIntProperty(this.objectIDs_[i], 5, parent_id);
                        cache.markObjectDeleted(this.objectIDs_[i]);
                        String contentLocalePref = CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE);
                        CMDbStoreLocalizedString defaultName = new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(contentLocalePref), String.valueOf(this.objectIDs_[i]));
                        ArrayList<String> namesForCache = new ArrayList<String>();
                        ArrayList<Integer> localesForCache = new ArrayList<Integer>();
                        namesForCache.add(defaultName.getValue());
                        localesForCache.add(new Integer(defaultName.getLocaleIDForCache()));
                        cache.CMCacheSetAllNames(this.objectIDs_[i], namesForCache, localesForCache);
                    }
                }
            }
            catch (CMException e) {
                CMException cmex = new CMException(e, "cmErrCommitMoveOp");
                CMIndications.logException(cmex);
            }
        }

        @Override
        public void rollback() {
        }
    }
}

