/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbmsInfo;
import com.cognos.cm.dbstore.binders.BlobInputStream;
import com.cognos.cm.dbstore.binders.CMDbStoreCLOBBinder;
import com.cognos.cm.util.CMInputStreamWithMetrics;
import com.cognos.cm.util.CMObjectRef;
import com.cognos.cm.util.io.TimedInputStream;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractDataBinder {
    private static final PerfTimer PERF_READ_TIMER = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.JDBC.readBLOB", (String)"The count and the time spent on BLOB reads from database", (int)5);

    protected void getBLOBDataFromDatabase(ResultSet rs, int getIndex, CMObjectRef valueByRef, InputStream value) throws SQLException {
        CMDbmsInfo dbms = CMDbConnection.getDbmsInfo();
        if (CMDbConnection.dbms_ == 1 && dbms.getDbmsDriverType() == 1) {
            value = rs.getBinaryStream(getIndex);
        } else if (CMDbConnection.dbms_ == 4) {
            value = rs.getBinaryStream(getIndex);
        } else {
            Blob bValue = rs.getBlob(getIndex);
            if (bValue != null) {
                value = new BlobInputStream(bValue);
            }
        }
        if (value != null) {
            value = new TimedInputStream(value, CMDbStoreCLOBBinder.READ_LOB_TIMER);
            if (PERF_READ_TIMER.getMeasure().isEnabled()) {
                value = new CMInputStreamWithMetrics(value, PERF_READ_TIMER);
            }
        }
        valueByRef.set(value);
    }
}

