/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

class BlobInputStream
extends InputStream {
    private Blob blob;
    private InputStream in;

    public BlobInputStream(Blob blob) {
        this.blob = blob;
    }

    private InputStream getStream() throws IOException {
        if (this.in == null) {
            try {
                this.in = this.blob.getBinaryStream();
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        return this.in;
    }

    @Override
    public int read() throws IOException {
        return this.getStream().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.getStream().read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.getStream().skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.getStream().available();
    }

    @Override
    public void close() throws IOException {
        this.getStream().close();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.getStream().mark(readlimit);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void reset() throws IOException {
        this.getStream().reset();
    }

    @Override
    public boolean markSupported() {
        try {
            return this.getStream().markSupported();
        }
        catch (IOException e) {
            return false;
        }
    }
}

