/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.binders.AbstractDataBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.util.CMInputStreamWithSize;
import com.cognos.cm.util.CMObjectRef;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreBLOBBinder
extends AbstractDataBinder
implements CMDbStoreDataBinder {
    @Override
    public final int bindData(PreparedStatement stmt, int bindIndex, Object value) throws SQLException {
        if (value == null) {
            if (CMDbConnection.dbms_ == 4) {
                stmt.setBinaryStream(bindIndex, (InputStream)null, 0);
            } else {
                stmt.setNull(bindIndex, 2004);
            }
        } else if (value instanceof byte[]) {
            byte[] theValue = (byte[])value;
            if (theValue.length > 5000 || CMDbConnection.getDbmsInfo().getDbms() == 3) {
                stmt.setBinaryStream(bindIndex, (InputStream)new ByteArrayInputStream(theValue), theValue.length);
            } else {
                stmt.setBytes(bindIndex, theValue);
            }
        } else if (value instanceof CMInputStreamWithSize) {
            CMInputStreamWithSize stream = (CMInputStreamWithSize)value;
            stmt.setBinaryStream(bindIndex, (InputStream)stream, (int)stream.length());
        } else {
            throw new IllegalStateException("Unknown data type passed to CMDbStoreBLOBBinder: " + value.getClass().getName());
        }
        return bindIndex + 1;
    }

    @Override
    public int getData(ResultSet rs, int getIndex, CMObjectRef valueByRef) throws SQLException {
        InputStream value = null;
        this.getBLOBDataFromDatabase(rs, getIndex, valueByRef, value);
        return getIndex + 1;
    }
}

