/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.util.CMInputStreamWithSize;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreBindUtil {
    public static final Counter writeLOB = new AccumulatingCounter().makeThreadLocal();
    private static final Timer writeLOBTimer = new Timer(writeLOB);
    private static final PerfTimer PERF_TIMER_WRITE_BLOB = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.JDBC.writeOracleBLOB", (String)"The number and the time spent on BLOB writes to Oracle database", (int)5);
    private static final PerfTimer PERF_TIMER_WRITE_CLOB = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.JDBC.writeOracleCLOB", (String)"The number and the time spent on CLOB writes to Oracle database", (int)5);

    public static int bindCLOBToResultSet(String value, ResultSet rs, int dbType, int bindPos) throws SQLException {
        if (value == null || value.length() == 0) {
            return bindPos;
        }
        if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver() && dbType == 2005) {
            if (rs == null) {
                return bindPos;
            }
            Writer outStream = null;
            PERF_TIMER_WRITE_CLOB.start();
            writeLOBTimer.start();
            try {
                outStream = CMDbConnection.getClobStream(rs, bindPos);
                for (int pos = 0; pos < value.length(); pos += 10240) {
                    outStream.write(value, pos, Math.min(value.length() - pos, 10240));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to write LOB data", ex);
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exception) {}
                }
                writeLOBTimer.stop();
                PERF_TIMER_WRITE_CLOB.stop();
            }
        }
        return bindPos + 1;
    }

    public static void bindCLOBToPreparedStatement(String value, PreparedStatement stmt, int dbType, int bindPos) throws SQLException {
        if (value == null || value.length() == 0) {
            if (CMDbConnection.dbms_ == 8) {
                stmt.setNull(bindPos, -1);
            } else {
                stmt.setNull(bindPos, 12);
            }
        } else {
            if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver() && dbType == 2005) {
                return;
            }
            if (dbType == 2005 && value.length() > 5000) {
                stmt.setCharacterStream(bindPos, (Reader)new StringReader(value), value.length());
            } else if (CMDbConnection.dbms_ == 8) {
                stmt.setObject(bindPos, (Object)value, -1);
            } else {
                stmt.setObject(bindPos, (Object)value, 12);
            }
        }
    }

    public static int bindBLOBToResultSet(byte[] value, ResultSet rs, int dbType, int bindPos) throws SQLException {
        if (value == null || value.length == 0) {
            return bindPos;
        }
        if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver()) {
            if (rs == null) {
                return bindPos;
            }
            OutputStream outStream = null;
            PERF_TIMER_WRITE_BLOB.start();
            writeLOBTimer.start();
            try {
                outStream = CMDbConnection.getBlobStream(rs, bindPos);
                for (int pos = 0; pos < value.length; pos += 10240) {
                    outStream.write(value, pos, Math.min(10240, value.length - pos));
                }
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to write LOB data", ex);
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exception) {}
                }
                writeLOBTimer.stop();
                PERF_TIMER_WRITE_BLOB.stop();
            }
        }
        return bindPos + 1;
    }

    public static void bindBLOBToPreparedStatement(byte[] value, PreparedStatement stmt, int dbType, int bindPos) throws SQLException {
        if (value == null || value.length == 0) {
            if (CMDbConnection.dbms_ == 4) {
                stmt.setBinaryStream(bindPos, (InputStream)null, 0);
            } else {
                stmt.setNull(bindPos, 2004);
            }
        } else {
            if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver()) {
                return;
            }
            if (dbType == 2004 && value.length > 5000) {
                stmt.setBinaryStream(bindPos, (InputStream)new ByteArrayInputStream(value), value.length);
            } else {
                stmt.setBytes(bindPos, value);
            }
        }
    }

    public static void bindBLOBAsStreamToPreparedStatement(CMInputStreamWithSize is, PreparedStatement stmt, int dbType, int bindPos) throws SQLException {
        if (is != null) {
            if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver()) {
                return;
            }
            throw new IllegalStateException("bindBLOBAsStream being called for non Oracle driver");
        }
        stmt.setNull(bindPos, 2004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int bindBLOBAsStreamToResultSet(CMInputStreamWithSize is, ResultSet rs, int dbType, int bindPos) throws SQLException {
        if (is == null) {
            return bindPos;
        }
        if (CMDbConnection.dbms_ == 2 && CMDbConnection.getDbmsInfo().getIsThinDriver()) {
            if (rs == null) {
                return bindPos;
            }
            OutputStream outStream = null;
            PERF_TIMER_WRITE_BLOB.start();
            writeLOBTimer.start();
            try {
                int byteCount;
                outStream = CMDbConnection.getBlobStream(rs, bindPos);
                byte[] buffer = new byte[10240];
                while ((byteCount = is.read(buffer)) > 0) {
                    outStream.write(buffer, 0, byteCount);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exception) {}
                }
                writeLOBTimer.stop();
                PERF_TIMER_WRITE_BLOB.stop();
            }
        } else {
            throw new IllegalStateException("bindBLOBAsStream being called for non Oracle driver");
        }
        return bindPos + 1;
    }
}

