/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreDB2CLOBReader;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.util.CMObjectRef;
import com.cognos.cm.util.CMReaderWithMetrics;
import com.cognos.cm.util.io.TimedReader;
import com.cognos.perfMonitor.PerfMonitor;
import com.cognos.perfMonitor.PerfTimer;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreCLOBBinder
implements CMDbStoreDataBinder {
    public static final Counter readLOB = new AccumulatingCounter().makeThreadLocal();
    public static final Timer READ_LOB_TIMER = new Timer(readLOB);
    private static final PerfTimer PERF_READ_TIMER = PerfMonitor.getThreadLocalTimer((String)"com.cognos.cm.JDBC.readCLOB", (String)"The count and the time spent on CLOB reads from database", (int)5);

    @Override
    public final int bindData(PreparedStatement stmt, int bindIndex, Object value) throws SQLException {
        if (value == null) {
            if (CMDbConnection.dbms_ == 4) {
                stmt.setBinaryStream(bindIndex, (InputStream)null, 0);
            } else {
                stmt.setNull(bindIndex, 2005);
            }
        } else if (value instanceof String) {
            String theValue = (String)value;
            if (theValue.length() > 5000) {
                stmt.setCharacterStream(bindIndex, (Reader)new StringReader(theValue), theValue.length());
            } else {
                stmt.setString(bindIndex, theValue);
            }
        } else if (value instanceof Reader) {
            stmt.setCharacterStream(bindIndex, (Reader)value);
        } else {
            throw new IllegalStateException("Unexpected data type passed to CMDbStoreCLOBBinder.bindData: " + value.getClass().getName());
        }
        return bindIndex + 1;
    }

    @Override
    public int getData(ResultSet rs, int getIndex, CMObjectRef valueByRef) throws SQLException {
        Reader streamReader = null;
        Clob clob = rs.getClob(getIndex);
        if (clob != null) {
            if (CMDbConnection.dbms_ == 3) {
                if (clob.getCharacterStream() != null) {
                    streamReader = new CMDbStoreDB2CLOBReader(clob);
                }
            } else {
                streamReader = clob.getCharacterStream();
            }
        }
        if (streamReader != null) {
            streamReader = new TimedReader(streamReader, READ_LOB_TIMER);
            if (PERF_READ_TIMER.getMeasure().isEnabled()) {
                streamReader = new CMReaderWithMetrics(streamReader, PERF_READ_TIMER);
            }
        }
        valueByRef.set(streamReader);
        return getIndex + 1;
    }
}

