/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreStringBinder;
import com.cognos.cm.util.CMObjectRef;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreMultilingualStringBinder
implements CMDbStoreDataBinder {
    private boolean usesLocaleMatching_;

    public CMDbStoreMultilingualStringBinder(boolean usesLocaleMatching) {
        this.usesLocaleMatching_ = usesLocaleMatching;
    }

    @Override
    public final int bindData(PreparedStatement stmt, int bindIndex, Object parmValue) throws SQLException {
        if (parmValue == null) {
            throw new IllegalStateException("Multiling string/token entry cannot be null");
        }
        if (parmValue.getClass() == String.class) {
            stmt.setString(bindIndex++, (String)parmValue);
        } else {
            Object[] value = (Object[])parmValue;
            stmt.setShort(bindIndex++, (Short)value[0]);
            CMDbStoreStringBinder.bind(stmt, bindIndex++, value[1]);
            stmt.setBoolean(bindIndex++, (Boolean)value[2]);
            if (value[3] != null) {
                stmt.setShort(bindIndex++, (Short)value[3]);
            } else {
                stmt.setNull(bindIndex++, 4);
            }
        }
        return bindIndex;
    }

    @Override
    public int getData(ResultSet rs, int getIndex, CMObjectRef valueByRef) throws SQLException {
        if (this.usesLocaleMatching_) {
            valueByRef.set(CMDbStoreStringBinder.get(rs, getIndex));
            return getIndex + 1;
        }
        Object[] value = new Object[]{new Short(rs.getShort(getIndex)), CMDbStoreStringBinder.get(rs, getIndex + 1), new Boolean(rs.getBoolean(getIndex + 2)), null};
        short mappedLocaleID = rs.getShort(getIndex + 3);
        if (!rs.wasNull()) {
            value[3] = new Short(mappedLocaleID);
        }
        valueByRef.set(value);
        return getIndex + 4;
    }
}

