/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.util.CMObjectRef;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreNameValuePairBinder
implements CMDbStoreDataBinder {
    @Override
    public final int bindData(PreparedStatement stmt, int bindIndex, Object valueToBind) throws SQLException {
        if (valueToBind == null) {
            throw new IllegalStateException("NameValuePair cannot be null");
        }
        Object[] datum = (Object[])valueToBind;
        if (datum[0] == null) {
            throw new IllegalStateException("Name cannot be null for NameValuePair");
        }
        stmt.setString(bindIndex, (String)datum[0]);
        if (CMDbConnection.dbms_ != 2 || !CMDbConnection.getDbmsInfo().getIsThinDriver()) {
            byte[] data = (byte[])datum[1];
            if (data != null && data.length > 5000 && CMDbConnection.dbms_ != 1) {
                stmt.setBinaryStream(bindIndex + 1, (InputStream)new ByteArrayInputStream(data), data.length);
            } else {
                stmt.setBytes(bindIndex + 1, data);
            }
        }
        return bindIndex + 2;
    }

    @Override
    public int getData(ResultSet rs, int getIndex, CMObjectRef valueByRef) throws SQLException {
        String name = rs.getString(getIndex);
        InputStream value = null;
        if (CMDbConnection.dbms_ == 1 || CMDbConnection.dbms_ == 4) {
            value = rs.getBinaryStream(getIndex + 1);
        } else {
            Blob bValue = rs.getBlob(getIndex + 1);
            if (rs.wasNull()) {
                bValue = null;
            }
            if (bValue != null) {
                value = bValue.getBinaryStream();
            }
        }
        valueByRef.set(new Object[]{name, value});
        return getIndex + 2;
    }
}

