/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.binders.AbstractDataBinder;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.dbstore.binders.ExternalRepositoryDataObject;
import com.cognos.cm.diagnostics.AccumulatingCounter;
import com.cognos.cm.diagnostics.Counter;
import com.cognos.cm.diagnostics.Timer;
import com.cognos.cm.externalRepository.ExternalObjectStoreConnectionProvider;
import com.cognos.cm.repositoryPluginAPI.DataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptor;
import com.cognos.cm.repositoryPluginAPI.IDataDescriptorProperty;
import com.cognos.cm.repositoryPluginAPI.IQueryParameter;
import com.cognos.cm.repositoryPluginAPI.IQueryParameters;
import com.cognos.cm.repositoryPluginAPI.IQueryResult;
import com.cognos.cm.repositoryPluginAPI.IQueryResultObjects;
import com.cognos.cm.repositoryPluginAPI.RepositoryConnection;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.repositoryPluginFramework.DataDescriptor;
import com.cognos.cm.repositoryPluginFramework.DefaultQueryParameters;
import com.cognos.cm.repositoryPluginFramework.QueryParameter;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.util.CMObjectRef;
import com.cognos.cm.util.ContentDispositionBuilder;
import com.cognos.cm.util.io.TimedInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class CMDbStoreRepositoryBinder
extends AbstractDataBinder
implements CMDbStoreDataBinder {
    private static final String SQL_ERR_CODE_NO_CONNECTION = "08001";
    private static final int CMID_COL = 1;
    public static final Counter readData = new AccumulatingCounter().makeThreadLocal();
    public static final Timer READ_DATA_TIMER = new Timer(readData);
    private final String dataType;
    private final String dataSize;
    private final Object isCompressed;
    private final int cmId;
    private final int parentId;

    public CMDbStoreRepositoryBinder() {
        this("", "", "", -1, -1);
    }

    public CMDbStoreRepositoryBinder(String dataType, String dataSize, Object isCompressed, int cmId, int parentId) {
        this.dataType = dataType;
        this.dataSize = dataSize;
        this.isCompressed = isCompressed;
        this.cmId = cmId;
        this.parentId = parentId;
    }

    @Override
    public final int bindData(PreparedStatement stmt, int bindIndex, Object value) throws SQLException {
        try {
            this.bindNull(stmt, bindIndex);
            CMStore store = CMExecutionContext.get().getStore();
            String storeID = store.getCache().getInternalStoreId(this.cmId).toString();
            String contentDisposition = this.buildContentDisposition(store);
            this.writeDataToRepository(storeID, value, this.dataType, contentDisposition, this.isCompressed);
            return bindIndex + 1;
        }
        catch (CMException e) {
            throw new SQLException(e.getMessage(), SQL_ERR_CODE_NO_CONNECTION, e);
        }
    }

    @Override
    public int getData(ResultSet rs, int getIndex, CMObjectRef valueByRef) throws SQLException {
        try {
            InputStream value = null;
            RepositoryConnection repositoryConnection = this.getRepositoryConnection();
            String documentID = this.getDocumentID(rs);
            if (repositoryConnection.objectExists(documentID)) {
                this.getBlobDataFromEOS(valueByRef, repositoryConnection, documentID);
            } else {
                this.getBLOBDataFromDatabase(rs, getIndex, valueByRef, value);
            }
            return getIndex + 1;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), SQL_ERR_CODE_NO_CONNECTION, e);
        }
    }

    String buildContentDisposition(CMStore store) throws CMException {
        return ContentDispositionBuilder.buildContentDisposition(this.cmId, store, this.dataType, this.dataSize, this.parentId);
    }

    private void writeDataToRepository(String storeID, Object value, Object dataType, String contentDisposition, Object compressed) throws SQLException {
        IDataDescriptor metadata = this.buildDataDescriptor(storeID, value, dataType, contentDisposition, compressed);
        Properties properties = new Properties();
        try {
            RepositoryConnection repositoryConnection = this.getRepositoryConnection();
            repositoryConnection.writeData(metadata, properties);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage(), SQL_ERR_CODE_NO_CONNECTION, e);
        }
    }

    RepositoryConnection getRepositoryConnection() throws CMException {
        ExternalObjectStoreConnectionProvider repositoryConnectionProvider = ExternalObjectStoreConnectionProvider.getInstance();
        RepositoryConnection repositoryConnection = repositoryConnectionProvider.getRepositoryConnection();
        if (repositoryConnection == null) {
            throw new CMException("cmFaiedToConnectToRepository", new CMException.Parm("Connection", repositoryConnectionProvider.getRepositoryConnectionString()));
        }
        return repositoryConnection;
    }

    private IDataDescriptor buildDataDescriptor(String storeID, Object value, Object contentType, String contentDisposition, Object compressed) {
        DataDescriptor metadata = new DataDescriptor();
        metadata.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("documentObjectID", (Object)storeID));
        metadata.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("contentType", contentType));
        metadata.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("contentDisposition", (Object)contentDisposition));
        metadata.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("compressed", compressed));
        ExternalRepositoryDataObject dataObject = new ExternalRepositoryDataObject(value);
        metadata.addProperty((IDataDescriptorProperty)new DataDescriptorProperty("data", (Object)dataObject));
        return metadata;
    }

    private void bindNull(PreparedStatement stmt, int bindIndex) throws SQLException {
        if (CMDbConnection.dbms_ == 4) {
            stmt.setBinaryStream(bindIndex, (InputStream)null, 0);
        } else {
            stmt.setNull(bindIndex, 2004);
        }
    }

    private void getBlobDataFromEOS(CMObjectRef valueByRef, RepositoryConnection repositoryConnection, String documentID) throws SQLException {
        QueryParameter parameter = new QueryParameter("outputObjectID", (Object)documentID);
        DefaultQueryParameters parameters = new DefaultQueryParameters();
        parameters.put((IQueryParameter)parameter);
        IQueryResult result = null;
        try {
            result = repositoryConnection.queryObjects("getOutputContent", (IQueryParameters)parameters, null);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
        IQueryResultObjects objects = result.getObjects();
        objects.next();
        InputStream value = (InputStream)objects.getPropertyValue("contentStream");
        if (value != null) {
            value = new TimedInputStream(value, READ_DATA_TIMER);
        }
        valueByRef.set(value);
    }

    private String getDocumentID(ResultSet rs) throws SQLException, CMStoreNotAvailable, CMStoreUnexpected {
        int objectID = rs.getInt(1);
        CMExecutionContext executionContext = CMExecutionContext.get();
        CMStore store = executionContext.getStore();
        return store.getCache().getInternalStoreId(objectID).toString();
    }
}

