/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.util.CMObjectRef;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CMDbStoreStringBinder
implements CMDbStoreDataBinder {
    private static final String ORACLE_EMPTYSTRING = "\u0000";

    @Override
    public final int bindData(PreparedStatement stmt, int bindIndex, Object value) throws SQLException {
        CMDbStoreStringBinder.bind(stmt, bindIndex, value);
        return bindIndex + 1;
    }

    @Override
    public int getData(ResultSet rs, int getIndex, CMObjectRef valueByRef) throws SQLException {
        valueByRef.set(CMDbStoreStringBinder.get(rs, getIndex));
        return getIndex + 1;
    }

    public static final void bind(PreparedStatement stmt, int bindIndex, Object value) throws SQLException {
        if (value == null) {
            if (CMDbConnection.dbms_ == 8) {
                stmt.setNull(bindIndex, -1);
            } else {
                stmt.setNull(bindIndex, 12);
            }
        } else if (value.getClass() == String.class) {
            String bindValue = value.toString();
            if (bindValue.length() == 0 && (CMDbConnection.dbms_ == 2 || CMDbConnection.dbms_ == 4)) {
                bindValue = ORACLE_EMPTYSTRING;
            }
            stmt.setString(bindIndex, bindValue);
        } else {
            throw new IllegalStateException("Unexpected data type passed to CMDbStoreStringBinder.bindData: " + value.getClass().getName());
        }
    }

    public static final Object get(ResultSet rs, int getIndex) throws SQLException {
        String colValue = rs.getString(getIndex);
        if (colValue != null && (CMDbConnection.dbms_ == 2 || CMDbConnection.dbms_ == 4) && colValue.equals(ORACLE_EMPTYSTRING)) {
            colValue = "";
        }
        return colValue;
    }
}

