/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.dbstore.binders.CMDbStoreDataBinder;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMLocalTimestamp;
import com.cognos.cm.util.CMObjectRef;
import com.cognos.cmutils.date.DateUtils;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class CMDbStoreTimestampBinder
implements CMDbStoreDataBinder {
    @Override
    public final int bindData(PreparedStatement stmt, int bindIndex, Object value) throws SQLException {
        if (value == null) {
            stmt.setNull(bindIndex, 93);
        } else if (value instanceof CMLocalTimestamp) {
            Calendar cal = DateUtils.getGMTCalendar();
            stmt.setTimestamp(bindIndex, (CMLocalTimestamp)value, cal);
        } else {
            stmt.setTimestamp(bindIndex, (Timestamp)value);
        }
        return bindIndex + 1;
    }

    @Override
    public int getData(ResultSet rs, int getIndex, CMObjectRef valueByRef) throws SQLException {
        Timestamp ts = rs.getTimestamp(getIndex);
        if (ts != null && CMDateUtils.isTimeAroundFirstHourOfDSTTransition(ts)) {
            ts = rs.getTimestamp(getIndex, DateUtils.getDSTNeutralCalendar());
            ts = new CMLocalTimestamp(ts.getTime());
        }
        valueByRef.set(ts);
        return getIndex + 1;
    }
}

