/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.binders;

import com.cognos.cm.repositoryPluginAPI.DataObject;
import com.cognos.cm.repositoryPluginAPI.RepositoryException;
import com.cognos.cm.util.CMInputStreamWithSize;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Properties;

public class ExternalRepositoryDataObject
implements DataObject {
    InputStream data;
    long dataLength;

    ExternalRepositoryDataObject(Object value) {
        if (value == null) {
            this.data = null;
            this.dataLength = 0L;
        } else if (value instanceof byte[]) {
            byte[] theValue = (byte[])value;
            this.data = new ByteArrayInputStream(theValue);
            this.dataLength = theValue.length;
        } else if (value instanceof CMInputStreamWithSize) {
            CMInputStreamWithSize wrapper = (CMInputStreamWithSize)value;
            this.data = wrapper.stream();
            this.dataLength = wrapper.length();
        } else {
            throw new IllegalStateException("Unknown data type passed to CMDbStoreRepositoryBinder: " + value.getClass().getName());
        }
    }

    public InputStream getDataStream() throws RepositoryException {
        return this.data;
    }

    public Properties getProperties() throws RepositoryException {
        Properties properties = new Properties();
        properties.put("Content-Type", "application/octet-stream");
        properties.put("Content-Length", String.valueOf(this.dataLength));
        return properties;
    }

    public void release() {
    }

    public long getDataLength() throws RepositoryException {
        return this.dataLength;
    }
}

