/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.caching;

import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.caching.CMDbStoreObjectsProxy;
import com.cognos.cm.dbstore.caching.StoreObjectWithProperties;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.InternalStoreId;
import java.util.Map;

public class CacheReaderProxy
extends CMDbStoreObjectsProxy {
    private ICMProperty[] requestedProps;
    private Map<InternalStoreId, StoreObjectWithProperties> cachedObjects;

    public CacheReaderProxy(CMDbStoreObjects source, ICMProperty[] requestedProps, Map<InternalStoreId, StoreObjectWithProperties> cachedObjects) {
        super(source);
        this.requestedProps = requestedProps;
        this.cachedObjects = cachedObjects;
    }

    @Override
    public Object getValue(int index) throws CMException {
        ICMProperty prop = this.requestedProps[index];
        return this.getValue(prop);
    }

    @Override
    public Object getValue(ICMProperty prop) throws CMException {
        StoreObjectWithProperties cachedObj = this.getCachedObject();
        Object value = cachedObj != null && cachedObj.hasProperty(prop) ? cachedObj.get(prop) : super.getValue(prop);
        return value;
    }

    private StoreObjectWithProperties getCachedObject() {
        StoreObjectWithProperties cachedObj = null;
        InternalStoreId storeID = this.getInternalStoreID();
        if (storeID != null) {
            cachedObj = this.cachedObjects.get(storeID);
        }
        return cachedObj;
    }
}

