/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.caching;

import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.caching.CMDbStoreObjectsProxy;
import com.cognos.cm.dbstore.caching.LRUStoreObjectCache;
import com.cognos.cm.dbstore.caching.StoreObjectWithProperties;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.InternalStoreId;
import java.util.Set;

public class CacheWriterProxy
extends CMDbStoreObjectsProxy {
    private LRUStoreObjectCache lruCache;
    private ICMProperty[] requestedProps;
    private Set<ICMProperty> cacheableProps;
    private StoreObjectWithProperties currentObject;

    public CacheWriterProxy(CMDbStoreObjects source, ICMProperty[] requestedProps, Set<ICMProperty> cacheableProps, LRUStoreObjectCache cache) {
        super(source);
        this.requestedProps = requestedProps;
        this.cacheableProps = cacheableProps;
        this.lruCache = cache;
        this.currentObject = null;
    }

    @Override
    public boolean next() throws CMException {
        boolean hasNext = super.next();
        if (hasNext) {
            InternalStoreId storeID = this.getInternalStoreID();
            if (storeID == null) {
                this.currentObject = null;
            } else {
                this.currentObject = this.getCachedObject(storeID);
                if (this.currentObject.isMutable()) {
                    for (ICMProperty prop : this.cacheableProps) {
                        if (this.currentObject.hasProperty(prop)) continue;
                        this.currentObject.put(prop, super.getValue(prop));
                    }
                    this.currentObject.immutable();
                    this.lruCache.put(this.currentObject);
                }
            }
        }
        return hasNext;
    }

    private StoreObjectWithProperties getCachedObject(InternalStoreId storeID) {
        int version = this.getVersion();
        StoreObjectWithProperties obj = this.lruCache.get(storeID);
        if (obj == null || version != obj.getVersion()) {
            obj = new StoreObjectWithProperties(storeID, version);
        } else if (!obj.properties().containsAll(this.cacheableProps)) {
            obj = new StoreObjectWithProperties(obj);
        }
        return obj;
    }

    @Override
    public Object getValue(ICMProperty prop) throws CMException {
        Object value = this.currentObject != null && this.cacheableProps.contains(prop) ? this.currentObject.get(prop) : super.getValue(prop);
        return value;
    }

    @Override
    public Object getValue(int index) throws CMException {
        return this.getValue(this.requestedProps[index]);
    }
}

