/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.caching;

import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.caching.CacheReaderProxy;
import com.cognos.cm.dbstore.caching.CacheWriterProxy;
import com.cognos.cm.dbstore.caching.StoreObject;
import com.cognos.cm.dbstore.caching.StoreObjectWithProperties;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.util.LRUMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LRUStoreObjectCache {
    private static final Log log = LogFactory.getLog(LRUStoreObjectCache.class);
    private LRUMap<InternalStoreId, StoreObjectWithProperties> lruMap;
    private ICMProperty versionProp;

    public LRUStoreObjectCache(int capacity) {
        this(capacity, CMProperty.VERSION);
    }

    protected LRUStoreObjectCache(int capacity, ICMProperty versionProp) {
        this.versionProp = versionProp;
        this.lruMap = new LRUMap(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int capacity) {
        LRUMap<InternalStoreId, StoreObjectWithProperties> lRUMap = this.lruMap;
        synchronized (lRUMap) {
            this.lruMap.setMaxSize(capacity);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("setCapacity(" + capacity + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        LRUMap<InternalStoreId, StoreObjectWithProperties> lRUMap = this.lruMap;
        synchronized (lRUMap) {
            return this.lruMap.getMaxSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(StoreObjectWithProperties object) {
        StoreObjectWithProperties immutableObject = new StoreObjectWithProperties(object, false);
        LRUMap<InternalStoreId, StoreObjectWithProperties> lRUMap = this.lruMap;
        synchronized (lRUMap) {
            this.lruMap.put(immutableObject.getStoreID(), immutableObject);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(" + immutableObject.getStoreID() + ")"));
        }
    }

    public CMDbStoreObjects getCacheReader(CMDbStoreObjects source, Set<StoreObject> validators, ICMProperty[] props) {
        Set<ICMProperty> cacheableProps = this.getCacheableProps(props);
        if (cacheableProps == null) {
            return null;
        }
        HashMap<InternalStoreId, StoreObjectWithProperties> cachedResults = null;
        for (StoreObject validator : validators) {
            InternalStoreId storeID;
            StoreObjectWithProperties cachedObject;
            if (!this.validated(validator, cachedObject = this.get(storeID = validator.getStoreID()), cacheableProps)) {
                cachedResults = null;
                break;
            }
            if (cachedResults == null) {
                cachedResults = new HashMap<InternalStoreId, StoreObjectWithProperties>();
            }
            cachedResults.put(storeID, cachedObject);
        }
        CacheReaderProxy reader = null;
        if (cachedResults != null) {
            reader = new CacheReaderProxy(source, props, cachedResults);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCacheReader returning " + reader));
        }
        return reader;
    }

    public Set<ICMProperty> getCacheableProps(ICMProperty[] props) {
        HashSet<ICMProperty> cacheableProps = new HashSet<ICMProperty>();
        for (ICMProperty prop : props) {
            if (prop.isCached()) continue;
            if (this.isCacheable(prop)) {
                cacheableProps.add(prop);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("No caching support for property " + prop));
            }
            cacheableProps = null;
            break;
        }
        return cacheableProps;
    }

    public CMDbStoreObjects getCacheWriter(CMDbStoreObjects results, CMProperty[] properties, Set<ICMProperty> cacheableProps) {
        return new CacheWriterProxy(results, properties, cacheableProps, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evict(InternalStoreId storeID) {
        LRUMap<InternalStoreId, StoreObjectWithProperties> lRUMap = this.lruMap;
        synchronized (lRUMap) {
            this.lruMap.remove(storeID);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("evict " + storeID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LRUMap<InternalStoreId, StoreObjectWithProperties> lRUMap = this.lruMap;
        synchronized (lRUMap) {
            this.lruMap.clear();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"clear");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LRUMap<InternalStoreId, StoreObjectWithProperties> lRUMap = this.lruMap;
        synchronized (lRUMap) {
            return this.lruMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoreObjectWithProperties get(InternalStoreId storeID) {
        LRUMap<InternalStoreId, StoreObjectWithProperties> lRUMap = this.lruMap;
        synchronized (lRUMap) {
            return (StoreObjectWithProperties)this.lruMap.get(storeID);
        }
    }

    private boolean validated(StoreObject validator, StoreObjectWithProperties cachedObject, Set<ICMProperty> cacheableProps) {
        boolean validated = true;
        if (cachedObject == null) {
            validated = false;
        } else if (validator.getVersion() != cachedObject.getVersion()) {
            this.evict(cachedObject.getStoreID());
            validated = false;
        } else if (!cachedObject.properties().containsAll(cacheableProps)) {
            validated = false;
        }
        return validated;
    }

    protected boolean isCacheable(ICMProperty prop) {
        boolean isCalculated = prop.isInheritable() || prop.isDefaultMultilingualProperty();
        return !isCalculated;
    }
}

