/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.caching;

import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.caching.ResultsFilter;
import com.cognos.cm.dbstore.caching.SecurityReference;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class ResultsFilterByConsumers
extends ResultsFilter {
    private ICMProperty consumersProp;
    private Set<SecurityReference> identitySet;

    public ResultsFilterByConsumers(CMDbStoreObjects source) {
        this(source, (ICMProperty)CMProperty.CONSUMERS, CMExecutionContext.get().getCurrentUserIdentity());
    }

    public ResultsFilterByConsumers(CMDbStoreObjects source, ICMProperty consumersProp, List<CMObjectReference> identity) {
        super(source);
        this.consumersProp = consumersProp;
        this.identitySet = this.asCMIDSet(identity);
    }

    public ResultsFilterByConsumers(CMDbStoreObjects source, ICMProperty consumersProp, Set<SecurityReference> identitySet) {
        super(source);
        this.consumersProp = consumersProp;
        this.identitySet = identitySet;
    }

    @Override
    protected boolean accepted() throws CMException {
        if (!this.getObjectClass().hasProperty(this.consumersProp)) {
            return true;
        }
        return this.hasConsumersInIdentity(this.getValue(this.consumersProp));
    }

    private boolean hasConsumersInIdentity(Object value) {
        if (value == null) {
            return false;
        }
        Set<SecurityReference> consumersSet = this.asCMIDSet((CMDbStoreBaseClassArray)value);
        return CollectionUtils.containsAny(this.identitySet, consumersSet);
    }

    private Set<SecurityReference> asCMIDSet(CMDbStoreBaseClassArray bcArray) {
        HashSet<SecurityReference> cmidSet = new HashSet<SecurityReference>(bcArray.getSize(), 1.0f);
        for (int i = 0; i < bcArray.getSize(); ++i) {
            CMObjectReference ref = bcArray.getReference(i);
            SecurityReference secRef = new SecurityReference(ref);
            cmidSet.add(secRef);
        }
        return cmidSet;
    }

    private Set<SecurityReference> asCMIDSet(List<CMObjectReference> refList) {
        HashSet<SecurityReference> asCMIDSet = new HashSet<SecurityReference>(refList.size(), 1.0f);
        for (CMObjectReference ref : refList) {
            SecurityReference secRef = new SecurityReference(ref);
            asCMIDSet.add(secRef);
        }
        return asCMIDSet;
    }
}

