/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.caching;

import com.cognos.cm.dbstore.caching.ByteArrayReaderProvider;
import com.cognos.cm.dbstore.caching.StoreObject;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.InternalStoreId;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StoreObjectWithProperties
extends StoreObject {
    private static final Log log = LogFactory.getLog(StoreObjectWithProperties.class);
    private boolean mutable;
    private final HashMap<ICMProperty, Object> map;

    public StoreObjectWithProperties(InternalStoreId storeID, int version) {
        super(storeID, version);
        this.map = new HashMap();
        this.mutable = true;
    }

    public StoreObjectWithProperties(StoreObjectWithProperties otherObject) {
        this(otherObject, true);
    }

    public StoreObjectWithProperties(StoreObjectWithProperties otherObject, boolean mutable) {
        super(otherObject.getStoreID(), otherObject.getVersion());
        this.map = new HashMap<ICMProperty, Object>(otherObject.map);
        this.mutable = mutable;
    }

    public Set<ICMProperty> properties() {
        return this.map.keySet();
    }

    public Object get(ICMProperty prop) {
        Object value = this.map.get(prop);
        if (value instanceof ByteArrayReaderProvider) {
            ByteArrayReaderProvider reader = (ByteArrayReaderProvider)value;
            value = reader.getReader();
        }
        return value;
    }

    public void put(ICMProperty prop, Object value) throws CMException {
        if (!this.mutable) {
            throw new UnsupportedOperationException();
        }
        this.checkLegalPropValue(prop, value);
        Object cachedValue = value;
        if (value instanceof Reader) {
            try {
                cachedValue = new ByteArrayReaderProvider((Reader)value);
            }
            catch (IOException e) {
                throw new CMException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("put(" + prop.toString() + "," + value + ")"));
        }
        this.map.put(prop, cachedValue);
    }

    private void checkLegalPropValue(ICMProperty prop, Object value) {
        if (prop.equals(CMProperty.STOREID)) {
            InternalStoreId otherStoreID = new InternalStoreId(value.toString());
            if (!this.getStoreID().equals((Object)otherStoreID)) {
                throw new IllegalStateException(this.getStoreID() + "!=" + otherStoreID);
            }
        } else if (prop.equals(CMProperty.VERSION) && this.getVersion() != (Integer)value) {
            throw new IllegalStateException(this.getVersion() + "!=" + value);
        }
    }

    public boolean hasProperty(ICMProperty prop) {
        return this.map.containsKey(prop);
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void immutable() {
        this.mutable = false;
    }
}

