/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins;

import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.plugins.NodeSetFunction;
import com.cognos.cm.dbstore.plugins.Plugin;
import com.cognos.cm.dbstore.plugins.PropertyPlugin;
import com.cognos.cm.store.CMStore;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class PluginFactory {
    private final CMStoreMetadata metadata;
    private final ConcurrentHashMap<String, Plugin> nsFuncMap;
    private final ConcurrentHashMap<String, Plugin> propMap;

    public PluginFactory(CMStoreMetadata metadata) {
        this.metadata = metadata;
        this.nsFuncMap = new ConcurrentHashMap();
        this.propMap = new ConcurrentHashMap();
        String factoryClassName = this.getClass().getName();
        ResourceBundle bundle = ResourceBundle.getBundle(factoryClassName, new Locale("ov", "CA"));
        Enumeration<String> iter = bundle.getKeys();
        while (iter.hasMoreElements()) {
            String className = iter.nextElement();
            try {
                Class<?> clazz = Class.forName(className);
                this.loadPlugin(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load plugin: " + className, e);
            }
        }
    }

    public void loadPlugin(Class clazz) {
        block4: {
            String className = clazz.getName();
            Class[] argTypes = new Class[]{CMStoreMetadata.class};
            Object[] pluginArgs = new Object[]{this.metadata};
            try {
                Constructor constructor = clazz.getConstructor(argTypes);
                Plugin plugin = (Plugin)constructor.newInstance(pluginArgs);
                String pluginName = plugin.getName();
                if (plugin instanceof NodeSetFunction) {
                    this.nsFuncMap.put(pluginName, plugin);
                    break block4;
                }
                if (plugin instanceof PropertyPlugin) {
                    this.propMap.put(pluginName, plugin);
                    break block4;
                }
                throw new RuntimeException("Unrecognized plugin: " + className + " type=" + plugin.getClass());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load plugin: " + className, e);
            }
        }
    }

    public Plugin getSearchPathFunction(CMStore store, String funcName) {
        return this.nsFuncMap.get(funcName);
    }

    public PropertyPlugin getPropertyFunction(CMStore store, String propName) {
        return (PropertyPlugin)this.propMap.get(propName);
    }
}

