/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMDbStoreSecurityQueryResults;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.plugins.NodeSetFunctionBaseImpl;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import java.util.List;

public class CAMID
extends NodeSetFunctionBaseImpl {
    public CAMID(CMStoreMetadata metadata) {
        super(metadata);
    }

    @Override
    public CMStoreQueryResults execute(CMStore store, CMStorePathStep firstStep, ICMStorePath context, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, int skipObjects, int maxObjects) throws CMException {
        CMDbStore dbStore = (CMDbStore)store;
        String CAMID2 = null;
        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)firstStep.Predicates.get(0);
        if (parsedFunc.args.size() > 0) {
            CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)parsedFunc.args.get(0);
            CMStorePredicateStringLiteral camidLiteral = (CMStorePredicateStringLiteral)arg.PredicateExpressions.get(0);
            CAMID2 = camidLiteral.literal;
        }
        if (CAMID2 != null) {
            CAMIDHelper helper = new CAMIDHelper(permissions, context, operation, CAMID2, dbStore);
            if (CMCAMIDHelper.CAMIDIsExternal(CAMID2)) {
                String namespaceID = CMCAMIDHelper.getNamespaceIDFromCAMID(CAMID2);
                if (helper.isExternalCAMSearch()) {
                    return new CMDbStoreSecurityQueryResults(dbStore, context, properties, orderBy, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission, skipObjects, maxObjects);
                }
                CMStoreXPath newPath = helper.getCMStoreXPath(namespaceID, "namespace");
                try {
                    return new CMDbStoreCacheQueryResults(dbStore, newPath, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
                }
                catch (CMCacheException e) {
                    throw new CMStoreUnexpected(e, "cmStoreUnexpected");
                }
                catch (CMCacheAccessDenied e) {
                    CMDbStoreSecurityUtil.convertAccessDeniedException(dbStore.getCache(), e);
                }
            } else {
                CMStoreXPath newPath = null;
                String namespaceID = CMCAMIDHelper.getNamespaceIDFromCAMID(CAMID2);
                try {
                    if (CAMID2.startsWith(":") && !CMCAMIDHelper.isFixedCAMID(CAMID2)) {
                        int object_id;
                        if (CAMID2.startsWith("::") && (object_id = CMCAMIDHelper.objectIdFromInternalCAMID(CAMID2)) > 0) {
                            String ref = dbStore.getCache().CMCacheGetSecurityReference(object_id);
                            if (ref != null && ref.equals("CAMID(\"" + CAMID2 + "\")")) {
                                int[] objectID = new int[]{object_id};
                                CMDbStoreCacheQueryResults results = new CMDbStoreCacheQueryResults(dbStore, objectID, context, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
                                results.setIsMembershipQuery();
                                return results;
                            }
                            int[] initialObject = new int[]{};
                            return new CMDbStoreCacheQueryResults(dbStore, initialObject, context, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
                        }
                        String cognosNSPath = CMCAMIDHelper.CognosNSPathFromCAMID(CAMID2);
                        newPath = helper.getCMStoreXPath(cognosNSPath);
                    }
                    if (newPath == null) {
                        newPath = helper.getCMStoreXPath(namespaceID, "*");
                    }
                    return new CMDbStoreCacheQueryResults(dbStore, newPath, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
                }
                catch (CMCacheException e) {
                    throw new CMStoreUnexpected(e, "cmStoreUnexpected");
                }
                catch (CMCacheAccessDenied e) {
                    CMDbStoreSecurityUtil.convertAccessDeniedException(dbStore.getCache(), e);
                }
            }
        }
        return null;
    }

    @Override
    public int[] getArgTypes() {
        return new int[]{5};
    }

    @Override
    public int getId() {
        return 15;
    }

    @Override
    public String getName() {
        return "CAMID";
    }

    private class CAMIDHelper {
        private int permissions = -1;
        private ICMStorePath context = null;
        private int operation = -1;
        private String camid = null;
        private CMDbStore dbStore = null;

        private CAMIDHelper() {
        }

        public CAMIDHelper(int permissions, ICMStorePath context, int operation, String camid, CMDbStore dbStore) {
            this();
            this.permissions = permissions;
            this.context = context;
            this.operation = operation;
            this.camid = camid;
            this.dbStore = dbStore;
        }

        public boolean isExternalCAMSearch() throws CMException {
            CMExecutionContext ctx = CMExecutionContext.get();
            if (this.isAllowAccmanCall() && this.isExternalCAMSearchPath() && this.operation == 0 && ctx.getAccManPassportID() != null) {
                if (CMCAMIDHelper.isOpenIDNamespaceObject(this.camid) && !this.camid.equals(ctx.getCurrentUser())) {
                    String nsid = CMCAMIDHelper.getNamespaceIDFromCAMID(this.camid);
                    return !CMExecutionContext.get().isUserAuthenticatedIntoNamespace(nsid);
                }
                return true;
            }
            return false;
        }

        private boolean isExternalCAMSearchPath() throws CMException {
            int numSteps = this.context.size();
            if (numSteps == 1) {
                return true;
            }
            if (numSteps == 2) {
                return this.isCAMQueryStep(this.context.stepAt(1));
            }
            return false;
        }

        private boolean isAllowAccmanCall() {
            return (this.permissions & 0x8000) == 0;
        }

        private boolean isCAMQueryStep(CMStorePathStep step) throws CMException {
            if (step.TestContainsWildCards()) {
                if (AdvancedSettings.CAMSEARCHDEFERREDLOCKING && this.context.getCacheResults() != null && this.context.getCacheResults().length == 0) {
                    return true;
                }
                int internalObjectID = this.dbStore.getInternalIdFromCAMID(this.camid);
                if (internalObjectID != 0) {
                    try {
                        int classID = this.dbStore.getCache().CMCacheGetClass(internalObjectID);
                        boolean isAccount = classID == CMObjectClass.ACCOUNT.getID();
                        boolean hasExternalPredicates = step.hasPredicatesReferencingExternalClass();
                        boolean hasInternalPredicates = step.hasPredicatesReferencingInternalClass();
                        if (!hasExternalPredicates && !hasInternalPredicates) {
                            return !isAccount;
                        }
                        if (isAccount) {
                            return !hasInternalPredicates;
                        }
                        return hasExternalPredicates;
                    }
                    catch (CMCacheException ex) {
                        throw new CMStoreUnexpected(ex, "cache exception");
                    }
                }
                return true;
            }
            return false;
        }

        private CMStoreXPath getCMStoreXPath(String namespaceID, String directorySubPath) throws CMStoreParseException {
            String newPathStr = "/directory/";
            newPathStr = newPathStr + directorySubPath;
            newPathStr = newPathStr + "[@id=";
            newPathStr = newPathStr + CMStoreXPath.attributeQuoteString(namespaceID);
            newPathStr = newPathStr + "]";
            newPathStr = newPathStr + "//*[@id='";
            newPathStr = newPathStr + CMStoreXPath.attributeEncodeString(this.camid, '\'');
            newPathStr = newPathStr + "']";
            return this.getCMStoreXPath(newPathStr);
        }

        private CMStoreXPath getCMStoreXPath(String path) throws CMStoreParseException {
            CMStoreXPath newPath = new CMStoreXPath(path, this.context.getLockManagerUsageFlag());
            newPath.append(this.context, 1);
            newPath.setLocksHaveBeenObtained();
            return newPath;
        }
    }
}

