/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.plugins.NodeSetFunctionBaseImpl;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.trustedServices.trustedService;
import java.util.List;

public class CamInternal
extends NodeSetFunctionBaseImpl {
    public CamInternal(CMStoreMetadata metadata) {
        super(metadata);
    }

    @Override
    public CMStoreQueryResults execute(CMStore store, CMStorePathStep firstStep, ICMStorePath path, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, int skipObjects, int maxObjects) throws CMException {
        trustedService currService = CMExecutionContext.get().getTrustedService();
        if (currService == null || !currService.getFullyTrusted()) {
            throw new CMException("cmRequestNotTrusted");
        }
        CMDbStore dbStore = (CMDbStore)store;
        String searchPath = this.getSearchPath(firstStep);
        try {
            CMStoreXPath query2 = new CMStoreXPath(searchPath);
            CMDbStoreCacheQueryResults dbStoreCacheQueryResults = new CMDbStoreCacheQueryResults(dbStore, query2, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
            dbStoreCacheQueryResults.setIsCAMInternal(true);
            return dbStoreCacheQueryResults;
        }
        catch (CMCacheAccessDenied ex) {
            CMDbStoreSecurityUtil.convertAccessDeniedException(dbStore.getCache(), ex);
        }
        catch (CMCacheException ex) {
            throw new CMStoreUnexpected(ex, "cmStoreUnexpected");
        }
        return null;
    }

    private String getSearchPath(CMStorePathStep firstStep) {
        String searchPath = null;
        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)firstStep.Predicates.get(0);
        if (parsedFunc.args.size() > 0) {
            CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)parsedFunc.args.get(0);
            CMStorePredicateStringLiteral camidLiteral = (CMStorePredicateStringLiteral)arg.PredicateExpressions.get(0);
            searchPath = camidLiteral.literal;
        }
        return searchPath;
    }

    @Override
    public int[] getArgTypes() {
        return new int[]{5};
    }

    @Override
    public int getId() {
        return 33;
    }

    @Override
    public String getName() {
        return CMConstants.FUNC_CAMINTERNAL_DEF.getName();
    }
}

