/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.CAM.AAAException;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheComplexObjects;
import com.cognos.cm.dbstore.CMDbStoreCacheObjects;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.CMDbStoreObjectsBase;
import com.cognos.cm.dbstore.CMDbStoreSelectDef;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.ObjectsWrapperQueryResults;
import com.cognos.cm.dbstore.PropertyArray;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.AccManAuthResponse;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMPreference;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.server.RequestHandler;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMDateUtils;
import com.cognos.cm.util.CMUUID;
import com.cognos.cm.util.DataEncryptionHelper;
import com.cognos.cmutils.properties.Credentials;
import com.cognos.cmutils.properties.IDataEncryptionHelper;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSourceSignonQueryResults
extends ObjectsWrapperQueryResults {
    protected CMDbStore store_;
    protected PropertyArray properties;
    protected int idxCredentialNamespaces_ = -1;
    protected int idxCredentials_ = -1;
    protected boolean currObjectVirtual_;
    protected boolean bNextCalledOnce_;
    protected boolean lastPropAcquired_;
    protected String credentialsValueString;
    protected int[] start_objects;
    protected int numStartObjects;
    protected ICMStorePath query;
    protected OrderByField[] orderBy;
    protected int action;
    protected int permissionFlags;
    protected String accManPassportID;
    protected ArrayList<String> appPerms;
    protected boolean useConsumersDbFilter = false;
    protected boolean bCredentialNamespacesRequired = false;
    protected boolean bCredentialsRequired = false;
    protected CMExecutionContext ctx;

    protected abstract CMCacheQueryInstance executeCacheQuery(CMCache var1, ICMStorePath var2, int var3, String var4, List<String> var5) throws CMException;

    public DataSourceSignonQueryResults(int[] start_objects, int numStartObjects, CMDbStore store, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int action, int permissionFlags, String accManPassportID, List<String> appPerms) {
        this.start_objects = start_objects;
        this.numStartObjects = numStartObjects;
        this.store_ = store;
        this.query = query2;
        this.properties = new PropertyArray(properties);
        this.orderBy = orderBy;
        this.action = action;
        this.permissionFlags = permissionFlags;
        this.accManPassportID = accManPassportID;
        this.appPerms = appPerms == null ? new ArrayList() : new ArrayList<String>(appPerms);
        this.ctx = CMExecutionContext.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CMStoreQueryResults execute() throws CMCacheException, CMCacheAccessDenied, CMException {
        if (this.query == null) {
            return this;
        }
        ArrayList<String> otherPermissions = new ArrayList<String>();
        String checkPolicies = ConfigurationFactory.getConfig().getInternalProp("CMCheckPolicies");
        this.removePermission(this.appPerms, "execute");
        int queryOpts = 0;
        if (checkPolicies != null && checkPolicies.equals("1") && (this.permissionFlags & 0x200) == 0) {
            queryOpts = this.computePermissionsAndOptions(this.query, this.action, this.ctx.getServiceId(), this.permissionFlags, this.appPerms, otherPermissions);
        }
        ArrayList<String> passToCachePerms = this.merge(this.appPerms, otherPermissions);
        if ((this.permissionFlags & 0x200) != 0 || (queryOpts & 0x80) != 0) {
            this.accManPassportID = null;
        } else if (this.ctx.getCurrentUserIsAdministrator()) {
            this.accManPassportID = null;
        }
        if ((this.permissionFlags & 0x1000) != 0) {
            queryOpts |= 0x40;
        }
        if (this.action == 4 || this.action == 2 || this.action == 8) {
            queryOpts |= 2;
        }
        CMCacheQueryInstance cacheQuery = null;
        try {
            cacheQuery = this.executeCacheQuery(this.store_.getCache(), this.query, this.action, this.accManPassportID, passToCachePerms);
            this.processResultObjects(cacheQuery);
            if (this.bCredentialNamespacesRequired) {
                this.idxCredentialNamespaces_ = this.findProperty(CMProperty.CREDENTIALNAMESPACES);
                if (this.idxCredentialNamespaces_ == -1) {
                    this.idxCredentialNamespaces_ = this.appendProperty(CMProperty.CREDENTIALNAMESPACES);
                }
            }
            if (this.findProperty(CMProperty.REPOSITORYCREDENTIALS) != -1) {
                this.bCredentialsRequired = true;
                this.idxCredentials_ = this.findProperty(CMProperty.CREDENTIALS);
            }
            if (this.bCredentialsRequired && this.idxCredentials_ < 0) {
                this.idxCredentials_ = this.appendProperty(CMProperty.CREDENTIALS);
            }
            boolean mightSelectBurstOutput = false;
            try {
                if (this.action != 2 && this.action != 8) {
                    mightSelectBurstOutput = CMDbStoreUtil.mightSelectBurstOutput(this.store_, cacheQuery);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.objects_ = this.getObjectsResult(cacheQuery, otherPermissions, queryOpts, mightSelectBurstOutput);
            cacheQuery = null;
            this.currObjectVirtual_ = false;
        }
        finally {
            if (cacheQuery != null) {
                try {
                    cacheQuery.release();
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }

    protected CMDbStoreObjects getObjectsResult(CMCacheQueryInstance cacheQuery, ArrayList<String> otherPermissions, int queryOpts, boolean mightSelectBurstOutput) throws CMException {
        CMDbStoreObjectsBase objects;
        CMDbStoreSelectDef selectStmt;
        int[] objectIds = null;
        Object[] ancestorIds = null;
        CMStorePathStep lastStep = this.computeLastStep();
        if (lastStep != null && lastStep.hasAcquirablePropertyPredicate()) {
            objectIds = cacheQuery.resultObjects();
            ancestorIds = CMDbStoreUtil.getAncestorIds(this.store_, objectIds);
        }
        if ((selectStmt = new CMDbStoreSelectDef(this.store_.getConnection(), lastStep, this.properties.getArray(), this.orderBy, mightSelectBurstOutput, true, cacheQuery.getDistinctSelectedClasses(), cacheQuery.getSelectionHasPolicies(), ancestorIds, objectIds, 0)).resolvableInCache()) {
            objects = new CMDbStoreCacheObjects(this.store_, selectStmt.getProperties(), cacheQuery);
        } else {
            int[] filterPermissions = null;
            objects = new CMDbStoreCacheComplexObjects(this.store_, selectStmt, this.appPerms, filterPermissions, otherPermissions, queryOpts, cacheQuery, null);
        }
        return objects;
    }

    protected void processResultObjects(CMCacheQueryInstance cacheQueryResult) throws CMCacheException, CMException {
        int[] classes = cacheQueryResult.resultClassIds();
        if (classes != null) {
            for (int iClass = 0; iClass < classes.length && !this.useConsumersDbFilter; ++iClass) {
                if (classes[iClass] == CMObjectClass.DATASOURCESIGNON.getID()) {
                    this.useConsumersDbFilter = true;
                    this.bCredentialNamespacesRequired = false;
                    continue;
                }
                if (classes[iClass] != CMObjectClass.DATASOURCECONNECTION.getID() && classes[iClass] != CMObjectClass.DATASOURCEFILECONNECTION.getID() || !cacheQueryResult.objectHasCredentialNamespaces(iClass)) continue;
                this.bCredentialNamespacesRequired = true;
            }
        }
        classes = null;
    }

    protected int findProperty(CMProperty prop) {
        return this.properties.indexOf(prop);
    }

    protected int appendProperty(CMProperty prop) {
        return this.properties.append(prop);
    }

    protected CMStorePathStep computeLastStep() {
        CMStorePathStep lastStep = null;
        if (this.query.size() > 0) {
            lastStep = this.query.stepAt(this.query.size() - 1);
        }
        if (this.useConsumersDbFilter && !this.isAdminQuery()) {
            this.addMatchesIdentityPredicate(lastStep);
        }
        return lastStep;
    }

    private ArrayList<String> merge(ArrayList<String> appPerms, ArrayList<String> otherPermissions) {
        ArrayList result = (ArrayList)appPerms.clone();
        for (int i = 0; i < otherPermissions.size(); ++i) {
            result.add(otherPermissions.get(i));
        }
        return result;
    }

    private void removePermission(ArrayList<String> appPerms, String permission) {
        for (int i = 0; i < appPerms.size(); ++i) {
            if (!appPerms.get(i).equals(permission)) continue;
            appPerms.remove(i);
        }
    }

    private int computePermissionsAndOptions(ICMStorePath query2, int action, String serviceId, int permissionFlags, ArrayList<String> appPerms, ArrayList<String> otherPermissions) {
        CMStorePathStep lastStep;
        int queryOpts = 0;
        if (permissionFlags != 0) {
            if ((permissionFlags & 2) != 0) {
                CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "write");
            }
            if ((permissionFlags & 1) != 0 || (permissionFlags & 0x400) != 0) {
                CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "read");
            }
            if ((permissionFlags & 0x400) != 0) {
                queryOpts |= 0x10;
            }
            if ((permissionFlags & 4) != 0) {
                CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "setPolicy");
            }
            if ((permissionFlags & 0x10) != 0) {
                queryOpts |= 4;
            }
        }
        if (query2.size() > 0 && (lastStep = query2.stepAt(query2.size() - 1)).requiresReadAccess()) {
            CMDbStoreCacheQueryResults.addPermissionToList(appPerms, "read");
        }
        this.checkAndSetPermission("write", appPerms, otherPermissions);
        this.checkAndSetPermission("setPolicy", appPerms, otherPermissions);
        if ((permissionFlags & 0x20) != 0) {
            this.checkAndSetPermission("read", appPerms, otherPermissions);
            this.checkAndSetPermission("setPolicy", appPerms, otherPermissions);
            this.checkAndSetPermission("execute", appPerms, otherPermissions);
            this.checkAndSetPermission("traverse", appPerms, otherPermissions);
        }
        if ((permissionFlags & 0x40) != 0) {
            this.checkAndSetPermission("execute", appPerms, otherPermissions);
        }
        if ((permissionFlags & 0x80) != 0) {
            this.checkAndSetPermission("traverse", appPerms, otherPermissions);
            queryOpts = action == 2 || action == 8 ? (queryOpts |= 0x80) : (queryOpts |= 8);
        }
        if ((permissionFlags & 0x800) != 0) {
            this.checkAndSetPermission("execute", appPerms, otherPermissions);
            queryOpts |= 0x20;
        }
        if ((permissionFlags & 8) != 0) {
            this.checkAndSetPermission("setPolicy", appPerms, otherPermissions);
            queryOpts |= 1;
        }
        if (serviceId != null) {
            this.checkAndSetPermission("execute", appPerms, otherPermissions);
        }
        return queryOpts;
    }

    private void checkAndSetPermission(String permission, ArrayList<String> srcPerms, ArrayList<String> dstPerms) {
        if (!CMDbStoreCacheQueryResults.hasPermission(srcPerms, permission)) {
            CMDbStoreCacheQueryResults.addPermissionToList(dstPerms, permission);
        }
    }

    private void addMatchesIdentityPredicate(CMStorePathStep step) {
        StringReader reader = new StringReader("@objectClass != 'dataSourceSignon' or matchesIdentity(@consumers)");
        CMPathStepTokenizer toker = new CMPathStepTokenizer(reader);
        CMStorePathPredicate consumerPredicate = null;
        try {
            consumerPredicate = new CMStorePathPredicate(toker, -1);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Encountered problem parsing the consumers predicate");
        }
        step.Predicates.add(consumerPredicate);
    }

    protected boolean isAdminQuery() {
        return (this.permissionFlags & 0x200) != 0;
    }

    @Override
    public boolean next() throws CMException {
        if (this.objects_ == null) {
            return false;
        }
        if (this.currObjectVirtual_) {
            this.currObjectVirtual_ = false;
        } else if (this.bNextCalledOnce_ && (this.objects_.getObjectClass() == CMObjectClass.DATASOURCECONNECTION || this.objects_.getObjectClass() == CMObjectClass.DATASOURCEFILECONNECTION) && this.idxCredentialNamespaces_ >= 0 && this.objects_.getValue(this.idxCredentialNamespaces_) != null) {
            this.currObjectVirtual_ = true;
            return true;
        }
        this.bNextCalledOnce_ = true;
        if (!this.objects_.next()) {
            return false;
        }
        this.credentialsValueString = null;
        return true;
    }

    @Override
    public Object getValue(int index) throws CMException {
        CMProperty property = this.properties.get(index);
        if (this.currObjectVirtual_) {
            this.lastPropAcquired_ = false;
            if (property == CMProperty.OBJECTCLASS) {
                return CMObjectClass.DATASOURCESIGNON;
            }
            if (property == CMProperty.DEFAULTNAME) {
                return this.getName();
            }
            if (property == CMProperty.SEARCHPATH) {
                return this.getSearchPath();
            }
            if (property == CMProperty.STOREID) {
                return this.getStoreID();
            }
            if (property == CMProperty.NAME) {
                CMDbStoreLocalizedStringArray names = new CMDbStoreLocalizedStringArray();
                String userLocale = CMExecutionContext.get().getPreference(CMPreference.CONTENTLOCALE);
                names.add(new CMDbStoreLocalizedString(CMDbStoreStringLocales.findLocale(userLocale), this.getName()));
                return names;
            }
            if (property == CMProperty.CREDENTIALS) {
                CMDbStoreString credentials = this.getCredentialsFromNamespace();
                if (credentials != null) {
                    return credentials;
                }
            } else if (property == CMProperty.REPOSITORYCREDENTIALS) {
                CMDbStoreString credentials = this.getCredentialsFromNamespace();
                if (credentials != null) {
                    return this.createBasicAuthenticationCredentials(credentials);
                }
            } else {
                if (property == CMProperty.CREATIONTIME) {
                    return new CMDbStoreString(CMDateUtils.getIsoDate());
                }
                if (property == CMProperty.MODIFICATIONTIME) {
                    return new CMDbStoreString(CMDateUtils.getIsoDate());
                }
                if (property == CMProperty.ANCESTORS) {
                    try {
                        CMAncestors propValue = this.store_.getCache().getAncestors(this.objects_.getObjectID(), CMDbStoreCacheUtil.getCacheSearchLocales());
                        propValue.addChild(this.objects_.getName(), this.objects_.getSearchPath(), this.objects_.getObjectClass().getName(), this.objects_.getStoreID());
                        return propValue;
                    }
                    catch (CMCacheException propValue) {}
                } else if (property == CMProperty.PARENT) {
                    CMDbStoreBaseClassArray value = new CMDbStoreBaseClassArray();
                    value.add(new CMDbStoreObjectReference(this.getParentSearchPath()));
                    return value;
                }
            }
            if (property.isInheritable()) {
                this.lastPropAcquired_ = true;
                return this.objects_.getValue(index);
            }
        } else {
            if (property == CMProperty.CREDENTIALS) {
                String credentialsString = this.getCredentials(index);
                if (credentialsString != null) {
                    return new StringReader(credentialsString);
                }
            } else if (property == CMProperty.REPOSITORYCREDENTIALS) {
                String credentialsString = this.getCredentials(this.idxCredentials_);
                if (credentialsString == null) {
                    return null;
                }
                return this.createBasicAuthenticationCredentials(new StringReader(credentialsString));
            }
            return super.getValue(index);
        }
        return null;
    }

    private String getCredentials(int index) throws CMException {
        Object propValueObject;
        if (this.credentialsValueString == null && (propValueObject = super.getValue(index)) != null) {
            this.credentialsValueString = RequestHandler.readAnyTypePropertyValueIntoString(propValueObject);
        }
        return this.credentialsValueString;
    }

    private CMDbStoreString getCredentialsFromNamespace() throws CMException {
        CMDbStoreBaseClassArray namespaces = (CMDbStoreBaseClassArray)this.objects_.getValue(this.idxCredentialNamespaces_);
        if (namespaces != null && namespaces.getSize() > 0 && namespaces.getItem(0) != null) {
            CMObjectReference ref = namespaces.getReference(0);
            String namespace = CMCAMIDHelper.CAMIDFromSearchPath(ref.getSearchPath());
            try {
                return new CMDbStoreString(AccMan.getCurrentUserCredentials(namespace));
            }
            catch (AAAException e) {
                this.handleUserCredentialsException(e);
            }
        }
        return null;
    }

    private String createBasicAuthenticationCredentials(Object credentialsValueObject) throws CMException {
        String credentialsPropertyName = CMProperty.CREDENTIALS.getName();
        try {
            EncryptingSession es = CMServlet.CAMFactory_.createEncryptingSession();
            DataEncryptionHelper encryptionHelper = new DataEncryptionHelper(es);
            String sEncodedEncryptedCredentials = RequestHandler.readAnyTypePropertyValueIntoString(credentialsValueObject);
            String repositoryCredentials = new Credentials((IDataEncryptionHelper)encryptionHelper).createBasicAuthenticationCredentials(sEncodedEncryptedCredentials);
            return repositoryCredentials;
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmPropReadFail", new CMException.Parm("Prop", credentialsPropertyName));
        }
    }

    @Override
    public boolean wasAcquired() {
        return this.currObjectVirtual_ ? this.lastPropAcquired_ : super.wasAcquired();
    }

    @Override
    public String getPath() {
        if (this.currObjectVirtual_) {
            return super.getSearchPath() + "/" + this.getName();
        }
        return super.getPath();
    }

    @Override
    public String getSearchPath() {
        String path = super.getSearchPath();
        if (this.currObjectVirtual_) {
            return path + "/" + CMObjectClass.DATASOURCESIGNON.getName();
        }
        return path;
    }

    public String getStoreID() {
        if (this.currObjectVirtual_) {
            return null;
        }
        return this.objects_.getStoreID();
    }

    @Override
    public int getParentObjectID() {
        return this.currObjectVirtual_ ? super.getObjectID() : super.getParentObjectID();
    }

    @Override
    public String getParentSearchPath() {
        return this.currObjectVirtual_ ? super.getSearchPath() : super.getParentSearchPath();
    }

    @Override
    public String getSecurityReference() {
        return null;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (this.currObjectVirtual_) {
            return name + new CMUUID().toString();
        }
        return name;
    }

    @Override
    public CMObjectClass getObjectClass() {
        return this.currObjectVirtual_ ? CMObjectClass.DATASOURCESIGNON : super.getObjectClass();
    }

    @Override
    public void reset() {
        this.bNextCalledOnce_ = false;
        this.currObjectVirtual_ = false;
        super.reset();
    }

    @Override
    public void rewind() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsRewind() {
        return false;
    }

    @Override
    public boolean supportsSkipObjects() {
        return false;
    }

    private void handleUserCredentialsException(AAAException e) throws CMException {
        try {
            AccManAuthResponse camRsp = new AccManAuthResponse(e.getMessage());
            if (camRsp.hasCAMException() && camRsp.isCAMExceptionRecoverable()) {
                throw new CMException((Exception)((Object)e), "cmAuthenticateFailed");
            }
            throw new CMStoreUnexpected((Exception)((Object)e), "cmNoCredentialAccessDataSource");
        }
        catch (CMException cmEx) {
            throw cmEx;
        }
        catch (Exception unknownEx) {
            throw new CMStoreUnexpected(unknownEx, "cmNoCredentialAccessDataSource");
        }
    }

    @Override
    public CMStore getStore() {
        return this.store_;
    }
}

