/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.caching.LRUStoreObjectCache;
import com.cognos.cm.dbstore.plugins.impl.DataSourceSignon;
import com.cognos.cm.dbstore.plugins.impl.DataSourceSignonQueryResults;
import com.cognos.cm.dbstore.plugins.impl.DefaultRepositoryConnectionResults;
import com.cognos.cm.dbstore.plugins.impl.DefaultRepositoryConnectionResultsWithCache;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.AdvancedSettingsObserver;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMIntList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRepositoryConnection
extends DataSourceSignon
implements AdvancedSettingsObserver {
    private static final Log log = LogFactory.getLog(DefaultRepositoryConnection.class);
    LRUStoreObjectCache lruCache = new LRUStoreObjectCache(this.getCacheCapacity());

    public DefaultRepositoryConnection(CMStoreMetadata metadata) {
        super(metadata);
        AdvancedSettings.addObserver(this);
    }

    @Override
    protected DataSourceSignonQueryResults getByNameQueryResults(ICMStorePath path, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, CMDbStore dbStore) throws CMCacheException, CMException {
        DefaultRepositoryConnectionResults results;
        LRUStoreObjectCache resultsLRUCache = this.getCacheCapacity() > 0 ? this.lruCache : null;
        String passportId = CMExecutionContext.get().getAccManPassportID();
        if (resultsLRUCache != null && orderBy == null) {
            log.debug((Object)"caching is enabled");
            results = new DefaultRepositoryConnectionResultsWithCache(dbStore, path, properties, operation, permissions, passportId, extraPermission, resultsLRUCache);
        } else {
            results = new DefaultRepositoryConnectionResults(dbStore, path, properties, orderBy, operation, permissions, passportId, extraPermission);
        }
        return results;
    }

    @Override
    protected DataSourceSignonQueryResults getByPathQueryResults(ICMStorePath path, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, CMDbStore dbStore, int numObjects, CMIntList start_objects) throws CMCacheException, CMException {
        throw new UnsupportedOperationException("defaultRepositoryConnection(<path>) not supported");
    }

    @Override
    public int[] getArgTypes() {
        return new int[]{5};
    }

    @Override
    public int getId() {
        return 36;
    }

    @Override
    public String getName() {
        return "defaultRepositoryConnection";
    }

    private int getCacheCapacity() {
        return AdvancedSettings.REPOSITORYCONNECTIONCACHESIZE.intValue();
    }

    @Override
    public void updateSettings() {
        int newCapacity = this.getCacheCapacity();
        int oldCapacity = this.lruCache.getCapacity();
        if (oldCapacity != newCapacity) {
            this.lruCache.setCapacity(newCapacity);
        }
    }
}

