/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.plugins.impl.DataSourceSignonQueryResults;
import com.cognos.cm.dbstore.plugins.impl.RepositoryConnectionIndexes;
import com.cognos.cm.multitenancy.ReadTenantFilter;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.List;

public class DefaultRepositoryConnectionResults
extends DataSourceSignonQueryResults {
    public DefaultRepositoryConnectionResults(CMDbStore store, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int action, int permissionFlags, String accManPassportID, List<String> appPerms) {
        super(null, 0, store, query2, properties, orderBy, action, permissionFlags, accManPassportID, appPerms);
    }

    @Override
    protected CMCacheQueryInstance executeCacheQuery(CMCache cache, ICMStorePath query2, int action, String accManPassportID, List<String> passToCachePerms) throws CMException {
        ReadTenantFilter previousFilter = this.ctx.getReadTenantFilter();
        boolean isCurrentUserAdmin = this.ctx.getCurrentUserIsAdministrator();
        boolean isCurrentUserBounded = this.ctx.hasReadTenantFilter();
        if (isCurrentUserAdmin || isCurrentUserBounded) {
            int tenantID = this.ctx.getCurrentUserTenantId();
            this.ctx.setReadTenantFilter(new ReadTenantFilter.FixedListTenantFilter(0, tenantID));
        }
        ICacheAccessMan accMan = cache.newAccessMan(accManPassportID);
        accMan.setPermissions(passToCachePerms);
        CMCacheQueryInstance result = cache.executeQuery(query2, action, accMan);
        if (isCurrentUserAdmin || isCurrentUserBounded) {
            this.ctx.setReadTenantFilter(previousFilter);
        }
        return result;
    }

    @Override
    protected void processResultObjects(CMCacheQueryInstance cacheQueryResult) throws CMException {
        int[] classIds = cacheQueryResult.resultClassIds();
        int[] cmIds = cacheQueryResult.resultObjects();
        if (classIds != null) {
            RepositoryConnectionIndexes repositoryConnectionIndexes = this.selectConnections(classIds, cmIds);
            if (repositoryConnectionIndexes.hasUniqueTenantIndex()) {
                repositoryConnectionIndexes.trimPublicObjects(cacheQueryResult);
            } else {
                if (repositoryConnectionIndexes.hasMultipleTenantIndexes()) {
                    throw this.createAmbuiguityException(repositoryConnectionIndexes.getDataSourceName(cmIds));
                }
                if (repositoryConnectionIndexes.hasMultiplePublicIndexes()) {
                    throw this.createAmbuiguityException(repositoryConnectionIndexes.getDataSourceName(cmIds));
                }
            }
        }
        super.processResultObjects(cacheQueryResult);
    }

    CMException createAmbuiguityException(String dataSourceName) {
        return new CMException("cmAmbiguousRepositoryConnection", new CMException.Parm("DATASOURCE_NAME", dataSourceName));
    }

    RepositoryConnectionIndexes selectConnections(int[] classIds, int[] cmIds) {
        RepositoryConnectionIndexes repositoryConnectionIndexes = new RepositoryConnectionIndexes(this.store_);
        for (int classIdx = 0; classIdx < classIds.length; ++classIdx) {
            int connectionTenantId;
            if (CMObjectClass.DATASOURCECONNECTION.getID() == classIds[classIdx]) {
                connectionTenantId = this.store_.getCache().CMCacheGetTenantID(cmIds[classIdx]);
                if (connectionTenantId == 0) {
                    repositoryConnectionIndexes.addPublicConnection(classIdx);
                    continue;
                }
                repositoryConnectionIndexes.addTenantConnection(classIdx);
                if (!repositoryConnectionIndexes.hasMultipleTenantIndexes()) continue;
                break;
            }
            if (CMObjectClass.DATASOURCESIGNON.getID() != classIds[classIdx] || (connectionTenantId = this.store_.getCache().CMCacheGetTenantID(cmIds[classIdx])) != 0) continue;
            repositoryConnectionIndexes.addPublicSignon(classIdx);
        }
        return repositoryConnectionIndexes;
    }
}

