/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheObjects;
import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.caching.LRUStoreObjectCache;
import com.cognos.cm.dbstore.caching.ResultsFilterByConsumers;
import com.cognos.cm.dbstore.caching.StoreObject;
import com.cognos.cm.dbstore.plugins.impl.DefaultRepositoryConnectionResults;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.ICMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.InternalStoreId;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefaultRepositoryConnectionResultsWithCache
extends DefaultRepositoryConnectionResults {
    private LRUStoreObjectCache lruCache;

    public DefaultRepositoryConnectionResultsWithCache(CMDbStore store, ICMStorePath query2, CMProperty[] properties, int action, int permissionFlags, String accManPassportID, List<String> appPerms, LRUStoreObjectCache lruCache) {
        super(store, query2, properties, null, action, permissionFlags, accManPassportID, appPerms);
        this.lruCache = lruCache;
    }

    @Override
    protected CMStorePathStep computeLastStep() {
        if (this.useConsumersDbFilter) {
            if (this.properties.indexOf(CMProperty.CONSUMERS) == -1) {
                this.properties.append(CMProperty.CONSUMERS);
            }
            this.useConsumersDbFilter = false;
        }
        return super.computeLastStep();
    }

    @Override
    protected CMDbStoreObjects getObjectsResult(CMCacheQueryInstance cacheQuery, ArrayList<String> otherPermissions, int queryOpts, boolean mightSelectBurstOutput) throws CMException {
        CMDbStoreObjects results = this.getCachedResults(cacheQuery);
        if (results == null) {
            results = super.getObjectsResult(cacheQuery, otherPermissions, queryOpts, mightSelectBurstOutput);
            results = this.wrapResultsInCacheWriter(results);
        }
        return results;
    }

    private CMDbStoreObjects getCachedResults(CMCacheQueryInstance cacheQuery) throws CMException {
        int[] cmids;
        Set<StoreObject> validators;
        CMDbStoreCacheObjects source = new CMDbStoreCacheObjects(this.store_, this.properties.getArray(), cacheQuery);
        CMDbStoreObjects cachedObjects = this.lruCache.getCacheReader(source, validators = this.getValidators(cmids = cacheQuery.resultObjects()), this.properties.getArray());
        if (cachedObjects != null) {
            cachedObjects = this.wrapResultsInConsumersFilter(cachedObjects);
        }
        return cachedObjects;
    }

    private CMDbStoreObjects wrapResultsInCacheWriter(CMDbStoreObjects results) {
        Set<ICMProperty> cacheableProps = this.lruCache.getCacheableProps(this.properties.getArray());
        if (cacheableProps != null) {
            results = this.lruCache.getCacheWriter(results, this.properties.getArray(), cacheableProps);
            results = this.wrapResultsInConsumersFilter(results);
        }
        return results;
    }

    private CMDbStoreObjects wrapResultsInConsumersFilter(CMDbStoreObjects results) {
        if (!this.isAdminQuery()) {
            results = new ResultsFilterByConsumers(results);
        }
        return results;
    }

    private Set<StoreObject> getValidators(int[] cmids) {
        HashSet<StoreObject> validators = new HashSet<StoreObject>();
        for (int cmid : cmids) {
            StoreObject validator = this.getValidator(cmid);
            validators.add(validator);
        }
        return validators;
    }

    private StoreObject getValidator(int cmid) {
        StoreObject validator;
        CMCache cmCache = this.store_.getCache();
        InternalStoreId storeID = cmCache.getInternalStoreId(cmid);
        if (storeID != null) {
            int version = cmCache.getVersionNumber(cmid);
            validator = new StoreObject(storeID, version);
        } else {
            validator = StoreObject.NULL;
        }
        return validator;
    }
}

