/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreSearchPathResults;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.plugins.NodeSetFunctionBaseImpl;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.ObjectClassMapping;
import com.cognos.cm.store.PropertyMapping;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ExpandMembers
extends NodeSetFunctionBaseImpl {
    private static final String INCLUDE_GROUPS_PARAM = "includeGroups";
    private static final String EVERYONE = "CAMID(\"::Everyone\")";
    private static final String ALL_AUTHENTICATED_USERS = "CAMID(\"::All Authenticated Users\")";
    private static final String ANONYMOUS = "CAMID(\"::Anonymous\")";
    protected Filter filter;
    protected CMProperty[] queryProperties;

    public ExpandMembers(CMStoreMetadata metadata) {
        super(metadata);
        this.initMetadata(metadata);
    }

    private void initMetadata(CMStoreMetadata metadata) {
        PropertyMapping propMap = metadata.getPropertyMap();
        this.queryProperties = new CMProperty[]{propMap.members(), propMap.searchPath(), propMap.objectClass()};
    }

    @Override
    public int[] getArgTypes() {
        return new int[]{1, 0x40000005};
    }

    @Override
    public int getId() {
        return 17;
    }

    @Override
    public String getName() {
        return "expandMembers";
    }

    @Override
    public int getReturnType() {
        return 1;
    }

    public boolean allowCompoundPathArguments() {
        return true;
    }

    protected void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void validatePredicateFunction(CMStorePathPredicateFunction predFunc) {
    }

    @Override
    public CMStoreQueryResults execute(CMStore store, CMStorePathStep firstStep, ICMStorePath path, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, int skipObjects, int maxObjects) throws CMException {
        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)firstStep.Predicates.get(0);
        ArrayList<String> searchPaths = new ArrayList<String>();
        boolean includeGroupsAndRoles = false;
        if (parsedFunc.args.size() > 0) {
            ICMStorePath arg = (ICMStorePath)parsedFunc.args.get(0);
            if (arg.isUnion()) {
                for (int i = 0; i < arg.size(); ++i) {
                    ICMStorePath newPath = arg.compoundPathElementAt(i);
                    searchPaths.add(newPath.toString());
                }
            } else {
                searchPaths.add(arg.toString());
            }
            if (parsedFunc.args.size() > 1) {
                includeGroupsAndRoles = INCLUDE_GROUPS_PARAM.equals(parsedFunc.getStringArgument(1));
            }
        }
        ArrayList<String> foundObjects = this.findMembers(store, searchPaths, includeGroupsAndRoles);
        String passportId = CMExecutionContext.get().getAccManPassportID();
        CMDbStoreSearchPathResults results = new CMDbStoreSearchPathResults(foundObjects, (CMDbStore)store, properties, orderBy, operation, permissions, passportId, extraPermission);
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> findMembers(CMStore store, ArrayList<String> querySearchPaths, boolean includeGroupsAndRoles) throws CMException {
        ArrayList<String> foundObjects = new ArrayList<String>();
        if (includeGroupsAndRoles && querySearchPaths.contains(EVERYONE)) {
            foundObjects.add(EVERYONE);
            return foundObjects;
        }
        ObjectClassMapping classMap = this.metadata.getClassMap();
        HashSet<String> alreadySeen = new HashSet<String>();
        ArrayList<String> moreToGo = querySearchPaths;
        boolean firstPass = true;
        while (!moreToGo.isEmpty()) {
            Iterator<String> iterPaths = moreToGo.iterator();
            moreToGo = new ArrayList();
            while (iterPaths.hasNext()) {
                String strSearch = iterPaths.next();
                CMStoreXPath objectContext = new CMStoreXPath(strSearch);
                CMStoreQueryResults results = null;
                try {
                    results = store.executeQuery(objectContext, this.queryProperties, null, 0, 512, null);
                }
                catch (CMStoreObjectNotFound e) {
                    continue;
                }
                try {
                    CMDbStoreBaseClassArray membersProp;
                    if (!results.next()) continue;
                    CMObjectClass objectClass = (CMObjectClass)results.getValue(2);
                    String strPath = results.getValue(1).toString();
                    alreadySeen.add(strPath);
                    if (objectClass == classMap.account() || objectClass == classMap.contact()) {
                        this.addToStringList(foundObjects, strPath);
                        continue;
                    }
                    if (includeGroupsAndRoles && !firstPass) {
                        if (EVERYONE.equals(strPath)) {
                            foundObjects.clear();
                            foundObjects.add(strPath);
                            ArrayList<String> arrayList = foundObjects;
                            return arrayList;
                        }
                        this.addToStringList(foundObjects, strPath);
                    }
                    if ((membersProp = (CMDbStoreBaseClassArray)results.getValue(0)) == null) continue;
                    for (int i = 0; i < membersProp.getSize(); ++i) {
                        String memberPath;
                        CMObjectReference member = (CMObjectReference)membersProp.getItem(i);
                        if (member == null || !this.allowMember(member) || !alreadySeen.add(memberPath = member.getSearchPath())) continue;
                        moreToGo.add(memberPath);
                    }
                }
                finally {
                    if (results == null) continue;
                    results.release();
                }
            }
            firstPass = false;
        }
        if (includeGroupsAndRoles) {
            this.handleSpecialGroups(alreadySeen, foundObjects);
        }
        return foundObjects;
    }

    private void handleSpecialGroups(HashSet<String> alreadySeen, ArrayList<String> foundObjects) {
        if (alreadySeen.contains(EVERYONE)) {
            foundObjects.clear();
            foundObjects.add(EVERYONE);
        } else if (alreadySeen.contains(ALL_AUTHENTICATED_USERS)) {
            foundObjects.clear();
            if (alreadySeen.contains(ANONYMOUS)) {
                foundObjects.add(EVERYONE);
            } else {
                foundObjects.add(ALL_AUTHENTICATED_USERS);
            }
        }
    }

    protected boolean allowMember(CMObjectReference member) {
        boolean bAllow = true;
        if (this.filter != null) {
            bAllow = this.filter.allow(member);
        }
        return bAllow;
    }

    private boolean addToStringList(ArrayList<String> foundObjects, String objectNewValue) {
        if (foundObjects.contains(objectNewValue)) {
            return false;
        }
        foundObjects.add(objectNewValue);
        return true;
    }

    protected static interface Filter {
        public boolean allow(CMObjectReference var1);
    }
}

