/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStoreObjects;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.plugins.PropertyPlugin;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;

abstract class FilterBCArrayBaseImpl
implements PropertyPlugin {
    protected CMStoreMetadata metadata;
    protected FuncMetadata funcMeta;

    public FilterBCArrayBaseImpl(CMStoreMetadata metadata, CMProperty filteredProp, CMProperty unfilteredProp) {
        this.metadata = metadata;
        this.funcMeta = new FuncMetadata();
        this.funcMeta.filteredProp = filteredProp;
        this.funcMeta.unfilteredProp = unfilteredProp;
    }

    @Override
    public String getName() {
        return this.funcMeta.filteredProp.getName();
    }

    public void getValue(CMDbStoreObjects objects, int index) throws CMException {
        objects.getValue(index);
    }

    @Override
    public Object getArrayValue(CMStore store, int objectID) throws CMException {
        String bcaPropName = this.funcMeta.unfilteredProp.getName();
        PropertyPlugin bcaPlugin = store.getPropertyFunction(bcaPropName);
        CMBaseClassArray bcaValue = (CMBaseClassArray)bcaPlugin.getArrayValue(store, objectID);
        if (bcaValue != null) {
            for (int i = 0; i < bcaValue.getSize(); ++i) {
                CMObjectReference ref = (CMObjectReference)bcaValue.getItem(i);
                if (this.allow(ref)) continue;
                bcaValue.removeItem(i);
                --i;
            }
            if (bcaValue.getSize() < 1) {
                bcaValue = null;
            }
        }
        return bcaValue;
    }

    private boolean allow(CMObjectReference ref) {
        CMObjectClass objectClass = ref.getObjectClass();
        boolean bAllowed = this.funcMeta.filteredProp.canReferenceClass(objectClass);
        return bAllowed;
    }

    public static class FuncMetadata {
        CMProperty filteredProp;
        CMProperty unfilteredProp;
    }
}

