/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.cache.ICacheAccessMan;
import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.plugins.impl.DataSourceSignonQueryResults;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.HashSet;
import java.util.List;

public class PersonalDataSourceSignonByNameResults
extends DataSourceSignonQueryResults {
    private HashSet<String> connectionNames = new HashSet();
    private int idxDataSourceConnectionName = -1;

    public PersonalDataSourceSignonByNameResults(CMDbStore store, ICMStorePath query2, CMProperty[] properties, OrderByField[] orderBy, int action, int permissionFlags, String AccManPassportID, List<String> appPerms) {
        super(null, 0, store, query2, properties, orderBy, action, permissionFlags, AccManPassportID, appPerms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CMCacheQueryInstance executeCacheQuery(CMCache cache, ICMStorePath query2, int action, String accManPassportID, List<String> passToCachePerms) throws CMException {
        ICacheAccessMan accMan = cache.newAccessMan(accManPassportID);
        accMan.setPermissions(passToCachePerms);
        CMCacheQueryInstance results = null;
        boolean success = false;
        try {
            results = cache.executeQuery(query2, action, accMan);
            this.gatherConnectionNames(results);
            this.idxDataSourceConnectionName = this.addMandatoryProperty(CMProperty.DATASOURCECONNECTIONNAME);
            success = true;
        }
        finally {
            if (!success && results != null) {
                results.release();
            }
        }
        return results;
    }

    private int addMandatoryProperty(CMProperty prop) {
        int index = this.findProperty(prop);
        if (index == -1) {
            index = this.appendProperty(prop);
        }
        return index;
    }

    private void gatherConnectionNames(CMCacheQueryInstance results) throws CMCacheException, CMException {
        int[] classIds = results.resultClassIds();
        int[] preferredLocales = CMDbStoreCacheUtil.getCacheSearchLocales();
        for (int i = 0; i < classIds.length; ++i) {
            if (classIds[i] != CMObjectClass.DATASOURCECONNECTION.getID()) continue;
            this.connectionNames.add(results.objectName(i, preferredLocales));
        }
    }

    @Override
    public boolean next() throws CMException {
        boolean hasNext = super.next();
        while (hasNext && this.skipObject()) {
            hasNext = super.next();
        }
        return hasNext;
    }

    private boolean skipObject() throws CMException {
        Object value;
        int skipClassId = CMObjectClass.DATASOURCECREDENTIAL.getID();
        return this.getObjectClass().getID() == skipClassId && ((value = this.getValue(this.idxDataSourceConnectionName)) == null || !this.connectionNames.contains(value.toString()));
    }

    @Override
    protected CMStorePathStep computeLastStep() {
        CMStorePathStep lastStep = super.computeLastStep();
        if (this.ctx.hasCapability("canUsePersonalDataSourceCredentials")) {
            String dataSourceName = this.getDataSourceName(lastStep);
            String escapedDataSourceName = CMStoreXPath.attributeQuoteString(dataSourceName);
            String predicateStrPre = "@objectClass != 'dataSourceCredential' or @dataSourceName = ";
            String predicateStr = predicateStrPre + escapedDataSourceName;
            lastStep.appendPredicate(predicateStr);
        }
        return lastStep;
    }

    private String getDataSourceName(CMStorePathStep step) {
        CMStorePathPredicateFunction predFunc = (CMStorePathPredicateFunction)step.Predicates.get(0);
        String dataSourceName = predFunc.getStringArgument(0);
        return dataSourceName;
    }
}

