/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMCacheQueryInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class RepositoryConnectionIndexes {
    CMDbStore store;
    List<Integer> publicConnections;
    List<Integer> publicSignons;
    List<Integer> tenantConnections;

    RepositoryConnectionIndexes(CMDbStore store) {
        this.store = store;
        this.publicConnections = new ArrayList<Integer>();
        this.tenantConnections = new ArrayList<Integer>();
        this.publicSignons = new ArrayList<Integer>();
    }

    void addPublicConnection(int classIndex) {
        this.publicConnections.add(classIndex);
    }

    void addPublicSignon(int classIndex) {
        this.publicSignons.add(classIndex);
    }

    void addTenantConnection(int classIndex) {
        this.tenantConnections.add(classIndex);
    }

    boolean hasMultipleTenantIndexes() {
        return this.tenantConnections.size() > 1;
    }

    boolean hasUniqueTenantIndex() {
        return this.tenantConnections.size() == 1;
    }

    boolean hasMultiplePublicIndexes() {
        return this.publicConnections.size() > 1;
    }

    String getDataSourceName(int[] cmIds) throws CMException {
        int connectionObjectId = 0;
        if (this.tenantConnections.size() > 0) {
            connectionObjectId = cmIds[this.tenantConnections.get(0)];
        } else if (this.publicConnections.size() > 0) {
            connectionObjectId = cmIds[this.publicConnections.get(0)];
        }
        String dataSourceName = "";
        if (connectionObjectId < 0) {
            return dataSourceName;
        }
        int parentObjectID = this.store.getCache().CMCacheGetParent(connectionObjectId);
        if (parentObjectID >= 0) {
            try {
                dataSourceName = this.store.getCache().CMCacheGetName(parentObjectID, CMDbStoreCacheUtil.getCacheSearchLocales());
            }
            catch (CMCacheException cMCacheException) {
                // empty catch block
            }
        }
        return dataSourceName;
    }

    void trimPublicObjects(CMCacheQueryInstance cacheQueryResult) throws CMCacheException {
        ArrayList<Integer> connectionsAndSignons = new ArrayList<Integer>(this.publicConnections);
        connectionsAndSignons.addAll(this.publicSignons);
        Collections.sort(connectionsAndSignons);
        for (int idx = 0; idx < connectionsAndSignons.size(); ++idx) {
            int classIdx = (Integer)connectionsAndSignons.get(idx) - idx;
            cacheQueryResult.trimObjects(classIdx, classIdx);
        }
    }
}

