/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.plugins.NodeSetFunctionBaseImpl;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateInteger;
import com.cognos.cm.store.path.ICMStorePath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class TenantRoots
extends NodeSetFunctionBaseImpl {
    public TenantRoots(CMStoreMetadata metadata) {
        super(metadata);
    }

    @Override
    public int getId() {
        return 35;
    }

    @Override
    public int[] getArgTypes() {
        return new int[]{5, 5};
    }

    @Override
    public CMStoreQueryResults execute(CMStore store, CMStorePathStep firstStep, ICMStorePath path, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, int skipObjects, int maxObjects) throws CMException {
        if ((permissions & 0x200) == 0) {
            throw new CMException("cmInvalidSearchPath", new CMException.Parm("Path", path.toString()));
        }
        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)firstStep.Predicates.get(0);
        CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)parsedFunc.args.get(0);
        int objectId = ((CMStorePredicateInteger)arg.PredicateExpressions.get((int)0)).digit;
        String tenantIdsArray = parsedFunc.args.get(1).toString();
        Set<Integer> tenantIds = this.parseInts(tenantIdsArray);
        CMDbStore dbStore = (CMDbStore)store;
        int[] ids = store.getCache().getTenantRootsUnder(objectId, tenantIds);
        return this.createResults(path, properties, orderBy, operation, permissions, extraPermission, dbStore, ids);
    }

    protected CMDbStoreCacheQueryResults createResults(ICMStorePath path, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, CMDbStore dbStore, int[] ids) throws CMCacheException, CMException {
        return new CMDbStoreCacheQueryResults(dbStore, ids, path, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
    }

    private Set<Integer> parseInts(String tenantIdsArray) {
        StringTokenizer tokenizer = new StringTokenizer(tenantIdsArray, "' ,", false);
        HashSet<Integer> result = new HashSet<Integer>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            result.add(Integer.parseInt(tokenizer.nextToken()));
        }
        return result;
    }

    @Override
    public String getName() {
        return "tenantRoots";
    }
}

