/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.plugins.impl;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheComplexObjects;
import com.cognos.cm.dbstore.CMDbStoreCacheQueryResults;
import com.cognos.cm.dbstore.CMDbStoreExceptionUtil;
import com.cognos.cm.dbstore.CMDbStoreSecurityQueryResults;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.dbstore.CMStoreMetadata;
import com.cognos.cm.dbstore.ICMDbStoreSqlGenerator;
import com.cognos.cm.dbstore.plugins.NodeSetFunctionBaseImpl;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.OrderByField;
import com.cognos.cm.store.CMCacheAccessDenied;
import com.cognos.cm.store.CMCacheException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;

public class URLID
extends NodeSetFunctionBaseImpl {
    public URLID(CMStoreMetadata metadata) {
        super(metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMStoreQueryResults execute(CMStore store, CMStorePathStep firstStep, ICMStorePath path, CMProperty[] properties, OrderByField[] orderBy, int operation, int permissions, List<String> extraPermission, int skipObjects, int maxObjects) throws CMException {
        CMDbStore dbStore = (CMDbStore)store;
        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)firstStep.Predicates.get(0);
        ICMDbStoreSqlGenerator sqlGenerator = dbStore.getConnection().getSqlGenerator();
        CMExecutionContext.checkCancelOrTimeOut();
        String sURLID = null;
        if (parsedFunc.args.size() > 0) {
            CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)parsedFunc.args.get(0);
            CMStorePredicateStringLiteral urlIDLiteral = (CMStorePredicateStringLiteral)arg.PredicateExpressions.get(0);
            sURLID = urlIDLiteral.literal;
        }
        boolean bValidPath = false;
        int iObjID = -1;
        if (sURLID != null) {
            CMDbStoreStringLocale sysLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(ConfigurationFactory.getConfig().getServerLocale().toString());
            byte[] data = Base64.decode(sURLID);
            String urlPath = new String(data);
            if (urlPath.startsWith("+1")) {
                int iColon = urlPath.indexOf(":");
                CMStoreXPath path1 = new CMStoreXPath(urlPath.substring(iColon + 1));
                return new CMDbStoreSecurityQueryResults(dbStore, path1, properties, orderBy, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
            }
            int iColon = urlPath.indexOf(":");
            iObjID = Integer.parseInt(urlPath.substring(0, iColon));
            if (!dbStore.isObjectIDValid(iObjID)) {
                return null;
            }
            int iColon2 = urlPath.indexOf(":", iColon + 1);
            long creationTime = Long.parseLong(urlPath.substring(iColon + 1, iColon2));
            long pathHash = Long.parseLong(urlPath.substring(iColon2 + 1));
            String cachePath = dbStore.getCache().CMCacheGetNameOnlyPath(iObjID, new int[]{sysLocale.getInternalID()});
            boolean bl = bValidPath = CMDbStoreCacheComplexObjects.hashPathForURL(cachePath) == pathHash;
            if (bValidPath) {
                PreparedStatement stmt;
                block15: {
                    StringBuffer selectString = new StringBuffer();
                    selectString.append(sqlGenerator.createSelectSql());
                    selectString.append("CMID");
                    selectString.append(sqlGenerator.createFromSql());
                    selectString.append("CMOBJECTS");
                    selectString.append(sqlGenerator.createWhereSql());
                    selectString.append("CMID");
                    selectString.append(sqlGenerator.createEqualsBindParameterSymbol());
                    selectString.append(sqlGenerator.createAndSql());
                    selectString.append("CREATED");
                    selectString.append(sqlGenerator.createEqualsBindParameterSymbol());
                    stmt = null;
                    try {
                        stmt = dbStore.getConnection().prepareStatement(selectString.toString());
                        stmt.setInt(1, iObjID);
                        stmt.setTimestamp(2, new Timestamp(creationTime));
                        ResultSet rs = stmt.executeQuery();
                        if (rs.next()) break block15;
                        bValidPath = false;
                    }
                    catch (SQLException ex) {
                        try {
                            CMDbStoreExceptionUtil.handleSQLException(dbStore.getConnection(), ex, "failed to read URLID object");
                        }
                        catch (Throwable throwable) {
                            CMDbStoreUtil.safeCloseStatement(stmt);
                            throw throwable;
                        }
                        CMDbStoreUtil.safeCloseStatement(stmt);
                    }
                }
                CMDbStoreUtil.safeCloseStatement(stmt);
            }
        }
        try {
            if (!bValidPath || iObjID < 0) {
                return new CMDbStoreCacheQueryResults(null, null, null, null, operation, permissions, null, null);
            }
            int[] initialObject = new int[]{iObjID};
            boolean bInCognosNS = dbStore.objectInCognosNamespace(iObjID);
            boolean bIsExternal = dbStore.getCache().CMCacheIsObjectExternal(iObjID);
            CMExecutionContext.checkCancelOrTimeOut();
            if (bIsExternal && !bInCognosNS) {
                String cachePath = dbStore.getObjectSearchPath(iObjID);
                CMStoreXPath path2 = new CMStoreXPath(cachePath);
                return new CMDbStoreSecurityQueryResults(dbStore, path2, properties, orderBy, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
            }
            return new CMDbStoreCacheQueryResults(dbStore, initialObject, path, properties, orderBy, operation, permissions, CMExecutionContext.get().getAccManPassportID(), extraPermission);
        }
        catch (CMCacheException e) {
            throw new CMStoreUnexpected(e, "cmStoreUnexpected");
        }
        catch (CMException ex) {
            throw new CMException((Exception)ex, "cmFuncInvocationFailure", new CMException.Parm("Function", parsedFunc.getName()));
        }
        catch (CMCacheAccessDenied e) {
            CMDbStoreSecurityUtil.convertAccessDeniedException(dbStore.getCache(), e);
            return null;
        }
    }

    @Override
    public int[] getArgTypes() {
        return new int[]{5};
    }

    @Override
    public int getId() {
        return 23;
    }

    @Override
    public String getName() {
        return "URLID";
    }
}

