/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.properties;

import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypeRender;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.util.CMSOAPWriter;

public class CMDbStoreLocalizedString
implements CMLocalizedString {
    private CMStringLocale locale_;
    private String value_;
    private boolean isDefault_;
    private boolean isDefaultForMappedLocale_;

    public CMDbStoreLocalizedString(CMStringLocale locale, String value, boolean isDefault, boolean isDefaultForMappedLocale) {
        this.locale_ = locale;
        this.value_ = value;
        this.isDefault_ = isDefault;
        this.isDefaultForMappedLocale_ = isDefaultForMappedLocale;
        if (this.locale_ == null) {
            throw new NullPointerException("CMStringLocale is null");
        }
    }

    public CMDbStoreLocalizedString(CMStringLocale locale, String value) {
        this(locale, value, false, false);
    }

    @Override
    public CMPropertyTypes.Type getType() {
        return CMPropertyTypes.BIBUS_MULTILINGUALSTRING;
    }

    @Override
    public CMStringLocale getLocale() {
        return this.locale_;
    }

    public CMStringLocale getMappedLocale() {
        short localeID = ((CMDbStoreStringLocale)this.locale_).getMappedID();
        if (localeID == -1) {
            return null;
        }
        return CMDbStoreStringLocales.findLocale(localeID);
    }

    @Override
    public String getValue() {
        return this.value_;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault_;
    }

    public boolean isDefaultForMappedLocale() {
        return this.isDefaultForMappedLocale_;
    }

    public void isDefault(boolean isDefault) {
        this.isDefault_ = isDefault;
    }

    public void isDefaultForMappedLocale(boolean isDefault) {
        this.isDefaultForMappedLocale_ = isDefault;
    }

    public int getLocaleIDForCache() {
        CMDbStoreStringLocale locale = (CMDbStoreStringLocale)this.locale_;
        int value = locale.getInternalID();
        value &= 0xFFFFFFFE;
        value |= this.isDefault() ? 1 : 0;
        if (this.isDefaultForMappedLocale_) {
            value |= locale.getMappedID() << 16;
        }
        return value;
    }

    @Override
    public String getXMLContent(CMProperty prop) {
        return this.getXMLContent();
    }

    @Override
    public String getXMLContent() {
        return CMPropertyTypeRender.renderLocalizedStringAsXML(this.locale_, this.value_);
    }

    @Override
    public void writeTo(CMSOAPWriter wrt, CMProperty prop) {
        ((CMSOAPWriter)wrt.element("locale")).type(CMPropertyTypes.XML_STRING);
        if (this.locale_ != null) {
            wrt.text(this.locale_.getLocaleID());
        }
        wrt.end();
        ((CMSOAPWriter)wrt.element("value")).type(CMPropertyTypes.XML_STRING);
        if (this.value_ != null) {
            wrt.text(this.value_);
        }
        wrt.end();
    }

    @Override
    public boolean isIdenticalTo(CMLocalizedString compareTo) {
        return this.locale_.getLocaleID().equals(compareTo.getLocale().getLocaleID()) && this.value_.equals(compareTo.getValue());
    }
}

