/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.properties;

import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArraySortByLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.properties.CMLocalizedString;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.util.CMSOAPWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CMDbStoreLocalizedStringArray
implements CMLocalizedStringArray {
    private final List<CMLocalizedString> localizedStrings = new ArrayList<CMLocalizedString>();

    @Override
    public Iterator<CMLocalizedString> iterator() {
        return this.localizedStrings.iterator();
    }

    @Override
    public int getSize() {
        return this.localizedStrings.size();
    }

    @Override
    public String getXMLItemContent(int index, CMProperty prop, int nTabs) {
        CMLocalizedString string = this.localizedStrings.get(index);
        return string.getXMLContent(prop);
    }

    public String getXMLItemContent(int index) {
        CMLocalizedString string = this.localizedStrings.get(index);
        return string.getXMLContent();
    }

    @Override
    public void writeTo(CMSOAPWriter wrt, CMProperty prop) {
        CMPropertyTypes.Type itemType = null;
        if (prop != null) {
            itemType = prop.getType().getEntryType();
        }
        for (CMLocalizedString str : this.localizedStrings) {
            wrt.element("item");
            if (itemType != null) {
                wrt.type(itemType);
            }
            str.writeTo(wrt, prop);
            wrt.end();
        }
    }

    @Override
    public Object getItem(int index) {
        return this.localizedStrings.get(index);
    }

    @Override
    public Object removeItem(int index) {
        return this.localizedStrings.remove(index);
    }

    @Override
    public CMPropertyTypes.Type getType() {
        return CMPropertyTypes.BIBUS_PARAMETERVALUEARRAY;
    }

    @Override
    public CMLocalizedString get(CMStringLocale locale) {
        int strCount = this.localizedStrings.size();
        for (int strIdx = 0; strIdx != strCount; ++strIdx) {
            CMLocalizedString str = this.localizedStrings.get(strIdx);
            if (str.getLocale() != locale) continue;
            return str;
        }
        return null;
    }

    @Override
    public String getDefault(CMStringLocale locale) {
        int mappedLocaleExactMatch = -1;
        int mappedLocaleMappedMatch = -1;
        int indFirstAsServerLocale = -1;
        int indFirstAsServerLocaleMapped = -1;
        int indFirstMappedAsServerLocaleMapped = -1;
        String serverLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
        short serverLocaleID = -2;
        short serverLocaleIDMapped = -2;
        if (serverLocale != null) {
            CMDbStoreStringLocale sysLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(serverLocale);
            serverLocaleID = sysLocale.getInternalID();
            serverLocaleIDMapped = sysLocale.getMappedID();
        }
        int strCount = this.localizedStrings.size();
        for (int strIdx = 0; strIdx != strCount; ++strIdx) {
            CMLocalizedString str = this.localizedStrings.get(strIdx);
            CMStringLocale strLocale = str.getLocale();
            if (strLocale == locale) {
                return str.getValue();
            }
            if (locale.getMappedLocale() == strLocale) {
                mappedLocaleExactMatch = strIdx;
            } else if (locale.getMappedLocale() == strLocale.getMappedLocale()) {
                mappedLocaleMappedMatch = strIdx;
            }
            CMDbStoreStringLocale dblocale = (CMDbStoreStringLocale)strLocale;
            short localeID = dblocale.getInternalID();
            short localeIDMapped = dblocale.getMappedID();
            if (indFirstAsServerLocale < 0 && serverLocaleID >= 0 && localeID == serverLocaleID) {
                indFirstAsServerLocale = strIdx;
            }
            if (indFirstAsServerLocaleMapped < 0 && serverLocaleIDMapped >= 0 && localeID == serverLocaleIDMapped) {
                indFirstAsServerLocaleMapped = strIdx;
            }
            if (indFirstMappedAsServerLocaleMapped >= 0 || serverLocaleIDMapped < 0 || localeIDMapped != serverLocaleIDMapped) continue;
            indFirstMappedAsServerLocaleMapped = strIdx;
        }
        if (this.localizedStrings.isEmpty()) {
            return null;
        }
        int defaultStringIndex = 0;
        if (mappedLocaleExactMatch >= 0) {
            defaultStringIndex = mappedLocaleExactMatch;
        } else if (mappedLocaleMappedMatch >= 0) {
            defaultStringIndex = mappedLocaleMappedMatch;
        } else if (indFirstAsServerLocale >= 0) {
            defaultStringIndex = indFirstAsServerLocale;
        } else if (indFirstAsServerLocaleMapped >= 0) {
            defaultStringIndex = indFirstAsServerLocaleMapped;
        } else if (indFirstMappedAsServerLocaleMapped >= 0) {
            defaultStringIndex = indFirstMappedAsServerLocaleMapped;
        } else {
            Collections.sort(this.localizedStrings, new CMDbStoreLocalizedStringArraySortByLocale());
        }
        return this.localizedStrings.get(defaultStringIndex).getValue();
    }

    @Override
    public void add(Object item) {
        this.localizedStrings.add((CMLocalizedString)item);
    }

    @Override
    public CMLocalizedString get(int index) {
        return this.localizedStrings.get(index);
    }

    @Override
    public void add(CMLocalizedString string) {
        this.localizedStrings.add(string);
    }

    public boolean canAdd(CMLocalizedString string) {
        int strCount = this.localizedStrings.size();
        for (int strIdx = 0; strIdx != strCount; ++strIdx) {
            CMLocalizedString str = this.localizedStrings.get(strIdx);
            if (str.getLocale() != string.getLocale()) continue;
            return false;
        }
        return true;
    }

    public void computeDefaults() {
        String advSettingsDefLocale;
        if (this.localizedStrings.isEmpty()) {
            return;
        }
        String serverLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
        short serverLocaleID = -2;
        short serverLocaleIDMapped = -2;
        short advSettingsDefaultLocaleID = -2;
        short advSettingsDefaultLocaleIDMapped = -2;
        if (serverLocale != null) {
            CMDbStoreStringLocale sysLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(serverLocale);
            serverLocaleID = sysLocale.getInternalID();
            serverLocaleIDMapped = sysLocale.getMappedID();
        }
        if ((advSettingsDefLocale = AdvancedSettings.DEFAULTLOCALE).length() != 0) {
            CMDbStoreStringLocale sysLocale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(advSettingsDefLocale);
            advSettingsDefaultLocaleID = sysLocale.getInternalID();
            advSettingsDefaultLocaleIDMapped = sysLocale.getMappedID();
        }
        Collections.sort(this.localizedStrings, new CMDbStoreLocalizedStringArraySortByLocale());
        CMDbStoreLocalizedString firstString = (CMDbStoreLocalizedString)this.localizedStrings.get(0);
        firstString.isDefaultForMappedLocale(true);
        if (this.localizedStrings.size() == 1) {
            firstString.isDefault(true);
            return;
        }
        CMStringLocale[] locales = new CMStringLocale[this.localizedStrings.size()];
        int mappedLocaleCount = 0;
        int indFirstAsServerLocale = -1;
        int indFirstAsServerLocaleMapped = -1;
        int indFirstMappedAsServerLocaleMapped = -1;
        int indFirstAsAdvSettingDefaultLocaleID = -1;
        int indFirstAsAdvSettingDefaultLocaleIDMapped = -1;
        int indFirstMappedAsAdvSettingDefaultLocaleMapped = -1;
        int strCount = this.localizedStrings.size();
        for (int strIdx = 0; strIdx != strCount; ++strIdx) {
            int localeIdx;
            CMDbStoreLocalizedString str = (CMDbStoreLocalizedString)this.localizedStrings.get(strIdx);
            CMStringLocale mappedLocale = str.getMappedLocale();
            CMStringLocale strLocale = str.getLocale();
            CMDbStoreStringLocale dblocale = (CMDbStoreStringLocale)strLocale;
            short localeID = dblocale.getInternalID();
            short localeIDMapped = dblocale.getMappedID();
            if (indFirstAsServerLocale < 0 && serverLocaleID >= 0 && localeID == serverLocaleID) {
                indFirstAsServerLocale = strIdx;
            }
            if (indFirstAsServerLocaleMapped < 0 && serverLocaleIDMapped >= 0 && localeID == serverLocaleIDMapped) {
                indFirstAsServerLocaleMapped = strIdx;
            }
            if (indFirstMappedAsServerLocaleMapped < 0 && serverLocaleIDMapped >= 0 && localeIDMapped == serverLocaleIDMapped) {
                indFirstMappedAsServerLocaleMapped = strIdx;
            }
            if (indFirstAsAdvSettingDefaultLocaleID < 0 && advSettingsDefaultLocaleID >= 0 && localeID == advSettingsDefaultLocaleID) {
                indFirstAsAdvSettingDefaultLocaleID = strIdx;
            }
            if (indFirstAsAdvSettingDefaultLocaleIDMapped < 0 && advSettingsDefaultLocaleIDMapped >= 0 && localeID == advSettingsDefaultLocaleIDMapped) {
                indFirstAsAdvSettingDefaultLocaleIDMapped = strIdx;
            }
            if (indFirstMappedAsAdvSettingDefaultLocaleMapped < 0 && advSettingsDefaultLocaleIDMapped >= 0 && localeIDMapped == advSettingsDefaultLocaleIDMapped) {
                indFirstMappedAsAdvSettingDefaultLocaleMapped = strIdx;
            }
            for (localeIdx = 0; localeIdx != mappedLocaleCount && locales[localeIdx] != mappedLocale; ++localeIdx) {
            }
            if (localeIdx != mappedLocaleCount) continue;
            str.isDefaultForMappedLocale(true);
            locales[mappedLocaleCount++] = mappedLocale;
        }
        if (indFirstAsServerLocale >= 0) {
            ((CMDbStoreLocalizedString)this.localizedStrings.get(indFirstAsServerLocale)).isDefault(true);
        } else if (indFirstAsServerLocaleMapped >= 0) {
            ((CMDbStoreLocalizedString)this.localizedStrings.get(indFirstAsServerLocaleMapped)).isDefault(true);
        } else if (indFirstMappedAsServerLocaleMapped >= 0) {
            ((CMDbStoreLocalizedString)this.localizedStrings.get(indFirstMappedAsServerLocaleMapped)).isDefault(true);
        } else if (indFirstAsAdvSettingDefaultLocaleID >= 0) {
            ((CMDbStoreLocalizedString)this.localizedStrings.get(indFirstAsAdvSettingDefaultLocaleID)).isDefault(true);
        } else if (indFirstAsAdvSettingDefaultLocaleIDMapped >= 0) {
            ((CMDbStoreLocalizedString)this.localizedStrings.get(indFirstAsAdvSettingDefaultLocaleIDMapped)).isDefault(true);
        } else if (indFirstMappedAsAdvSettingDefaultLocaleMapped >= 0) {
            ((CMDbStoreLocalizedString)this.localizedStrings.get(indFirstMappedAsAdvSettingDefaultLocaleMapped)).isDefault(true);
        } else {
            firstString.isDefault(true);
        }
    }

    @Override
    public boolean isIdenticalTo(CMLocalizedStringArray compareTo) {
        if (this.getSize() != compareTo.getSize()) {
            return false;
        }
        for (int i = 0; i < this.getSize(); ++i) {
            boolean foundIdentical = false;
            for (int j = 0; j < compareTo.getSize(); ++j) {
                if (!this.get(i).isIdenticalTo(compareTo.get(j))) continue;
                foundIdentical = true;
                break;
            }
            if (foundIdentical) continue;
            return false;
        }
        return true;
    }
}

