/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.properties;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;

public class CMDbStoreObjectReference
implements CMObjectReference {
    private CMObjectClass objectClass_;
    private int objectID_;
    private String searchPath_;
    private String securityReference_;
    private boolean resolved_;
    private boolean bExternal_;
    private boolean isSecurityReference_;
    private String storeID_;

    public CMDbStoreObjectReference(int objectID, CMObjectClass objectClass, String searchPath) {
        this.objectClass_ = objectClass;
        this.searchPath_ = searchPath;
        this.objectID_ = objectID;
        this.resolveSecurityReference();
        this.resolved_ = true;
        this.bExternal_ = false;
        this.isSecurityReference_ = true;
    }

    public CMDbStoreObjectReference(int objectID, CMObjectClass objectClass, String searchPath, boolean bExternal) {
        this.objectClass_ = objectClass;
        this.searchPath_ = searchPath;
        this.objectID_ = objectID;
        this.resolveSecurityReference();
        this.resolved_ = true;
        this.bExternal_ = bExternal;
        this.isSecurityReference_ = true;
    }

    public CMDbStoreObjectReference(int objectID, CMObjectClass objectClass, String searchPath, String securityRef) {
        this.objectClass_ = objectClass;
        this.searchPath_ = searchPath;
        this.securityReference_ = securityRef;
        this.objectID_ = objectID;
        this.resolved_ = true;
        this.bExternal_ = false;
        this.isSecurityReference_ = true;
    }

    public CMDbStoreObjectReference(int objectID, CMObjectClass objectClass, String searchPath, boolean bExternal, boolean isSecurityReference) {
        this.objectClass_ = objectClass;
        this.searchPath_ = searchPath;
        this.objectID_ = objectID;
        this.resolved_ = true;
        this.bExternal_ = bExternal;
        this.isSecurityReference_ = isSecurityReference;
    }

    public CMDbStoreObjectReference(String searchPath) {
        this.objectClass_ = null;
        this.searchPath_ = searchPath;
        this.objectID_ = -1;
        this.resolved_ = false;
        this.bExternal_ = false;
        this.isSecurityReference_ = false;
    }

    public CMDbStoreObjectReference(String searchPath, boolean bExternal) {
        this.objectClass_ = null;
        this.searchPath_ = searchPath;
        this.objectID_ = -1;
        this.resolved_ = false;
        this.bExternal_ = bExternal;
        this.isSecurityReference_ = true;
    }

    public CMDbStoreObjectReference(CMObjectClass objectClass, String searchPath, String securityRef) {
        this.objectClass_ = objectClass;
        this.searchPath_ = searchPath;
        this.securityReference_ = securityRef;
        this.objectID_ = -1;
        this.resolved_ = false;
        this.bExternal_ = false;
        this.isSecurityReference_ = true;
    }

    public CMDbStoreObjectReference(CMObjectClass objectClass, String searchPath) {
        this.objectClass_ = objectClass;
        this.searchPath_ = searchPath;
        this.securityReference_ = null;
        this.objectID_ = -1;
        this.resolved_ = false;
        this.bExternal_ = false;
        this.isSecurityReference_ = false;
    }

    public boolean isResolved() {
        return this.resolved_;
    }

    @Override
    public CMObjectClass getObjectClass() {
        return this.objectClass_;
    }

    @Override
    public String getSearchPath() {
        if (this.searchPath_ == null) {
            this.resolveSearchPath();
        }
        return this.searchPath_;
    }

    @Override
    public String getSecurityReference() {
        if (this.securityReference_ == null) {
            return this.searchPath_;
        }
        return this.securityReference_;
    }

    @Override
    public int getObjectID() {
        return this.objectID_;
    }

    public void setObjectID(int obj_id) {
        this.objectID_ = obj_id;
        this.resolved_ = true;
    }

    public void setSearchPath(String searchPath) {
        this.searchPath_ = searchPath;
    }

    @Override
    public String getXMLContent(CMProperty prop) {
        return null;
    }

    @Override
    public CMPropertyTypes.Type getType() {
        return CMPropertyTypes.XML_STRING;
    }

    @Override
    public boolean getIsExternal() {
        return this.bExternal_;
    }

    public void setIsExternal(boolean bExternal) {
        this.bExternal_ = bExternal;
    }

    public String toString() {
        if (this.searchPath_ == null) {
            this.resolveSearchPath();
        }
        return this.searchPath_;
    }

    public boolean isSecurityReference() {
        return this.isSecurityReference_;
    }

    @Override
    public String getStoreID() {
        return this.storeID_;
    }

    public void setStoreID(String storeID) {
        this.storeID_ = storeID;
    }

    private void resolveSecurityReference() {
        try {
            CMStore store = CMExecutionContext.get().getStore();
            this.securityReference_ = store.getObjectSecurityReference(this.objectID_);
        }
        catch (CMException cMException) {
            // empty catch block
        }
    }

    private void resolveSearchPath() {
        try {
            if (this.objectID_ == -1) {
                this.searchPath_ = this.securityReference_;
            } else {
                CMStore store = CMExecutionContext.get().getStore();
                this.searchPath_ = store.getObjectSearchPath(this.objectID_);
            }
        }
        catch (CMException cMException) {
            // empty catch block
        }
    }
}

