/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.properties;

import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.properties.CMStringLocale;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CMDbStoreStringLocales {
    public static final short LOCALE_MASK = -2;
    public static final short DEFAULT_MASK = 1;
    public static final short INVALID_LOCALE = 0;
    private static Map localesByID_ = new HashMap();
    private static Map localesByName_ = new HashMap();
    private static short nextLocaleID_ = (short)2;

    public static CMStringLocale findLocale(short localeID) {
        return (CMStringLocale)localesByID_.get(new Short((short)(localeID & 0xFFFFFFFE)));
    }

    public static CMStringLocale findLocale(String locale) {
        return (CMStringLocale)localesByName_.get(locale);
    }

    public static CMStringLocale getLocale(String localeID, CMStringLocale mappedLocale) {
        CMDbStoreStringLocale locale = (CMDbStoreStringLocale)CMDbStoreStringLocales.findLocale(localeID);
        if (locale == null) {
            short newLocaleID = nextLocaleID_;
            nextLocaleID_ = (short)(nextLocaleID_ + 2);
            short mappedLocaleID = 0;
            if (mappedLocale != null) {
                mappedLocaleID = ((CMDbStoreStringLocale)mappedLocale).getInternalID();
            }
            locale = new CMDbStoreStringLocale(newLocaleID, mappedLocaleID, localeID);
            localesByID_.put(new Short(locale.getInternalID()), locale);
            localesByName_.put(locale.getLocaleID(), locale);
        }
        return locale;
    }

    public static boolean isDefaultLocale(int localeCode) {
        return (localeCode & 1) != 0;
    }

    public static final int size() {
        return localesByID_.size();
    }

    public static final void loadLocales(ResultSet rs) throws SQLException {
        CMDbStoreStringLocales.clear();
        while (rs.next()) {
            CMDbStoreStringLocales.addLocale(rs.getShort(1), rs.getShort(2), rs.getString(3));
        }
    }

    public static final void saveLocales(PreparedStatement stmt) throws SQLException {
        Collection values = localesByID_.values();
        for (CMDbStoreStringLocale locale : values) {
            stmt.setShort(1, locale.getInternalID());
            stmt.setShort(2, locale.getMappedID());
            stmt.setString(3, locale.getLocaleID());
            stmt.executeUpdate();
        }
    }

    public static void clear() {
        localesByID_.clear();
        localesByName_.clear();
        nextLocaleID_ = (short)2;
    }

    public static void addLocale(short localeID, short mappedLocaleID, String localeName) {
        nextLocaleID_ = (short)Math.max(nextLocaleID_, localeID + 2);
        CMDbStoreStringLocale locale = new CMDbStoreStringLocale(localeID, mappedLocaleID, localeName);
        localesByID_.put(new Short(locale.getInternalID()), locale);
        localesByName_.put(locale.getLocaleID(), locale);
    }
}

