/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.securityproxy;

import com.cognos.CAM.AAAException;
import com.cognos.cm.dbstore.securityproxy.SecurityProxy;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMAAAObjectPropertiesDoc;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;

public class AccountProxy
extends SecurityProxy {
    private static CMProperty[] accountPropertiesToQueryForProxy;
    private static CMProperty accountUsernameProperty;
    private String tenantName;

    public AccountProxy(String camID, int parentID, String tenantName) {
        super(camID, CMObjectClass.ACCOUNT, parentID);
        this.tenantName = tenantName;
    }

    @Override
    public void createInStore(CMStore store) throws CMException {
        super.createInStore(store);
        this.createAccountChildren();
    }

    private void createAccountChildren() {
    }

    @Override
    protected void initializePropertyNameAndValueLists() throws CMException {
        super.initializePropertyNameAndValueLists();
        this.addCommonAccountPropertyNamesAndValues();
        this.addAccountSpecificPropertyValues();
    }

    protected void addAccountSpecificPropertyValues() {
        String userName;
        CMProperty useridProp;
        this.addPropertyNameValuePair(CMProperty.TENANTID, this.tenantName);
        String path = CMExecutionContext.get().getCurrentUserSearchPath();
        String defaultName = this.getDefaultNameOfSecurityObject(path);
        if (defaultName != null && defaultName.length() > 0) {
            this.addPropertyNameValuePair(CMProperty._FIRSTLOGONNAME, defaultName);
        }
        if ((useridProp = CMObjectClass.ACCOUNT.getProperty("_userid")) != null && (userName = this.getUserName()) != null) {
            this.addPropertyNameValuePair(useridProp, userName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchTenantAccountProfileProperties(CMProperty[] props, String tenantID) throws CMException {
        CMStoreQueryResults templateSrcQry;
        block3: {
            boolean bl;
            templateSrcQry = null;
            try {
                CMStore store = CMExecutionContext.get().getStore();
                CMStoreXPath tenantAccountPath = new CMStoreXPath("/configuration/account[@tenantID='" + CMStoreXPath.attributeEncodeString(tenantID) + "']", 16);
                templateSrcQry = store.executeQuery(tenantAccountPath, props, null, 0, 512, null);
                if (templateSrcQry.next()) break block3;
                bl = false;
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(templateSrcQry);
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(templateSrcQry);
            return bl;
        }
        this.getPropValuesFromQueryResult(props, templateSrcQry);
        CMQueryUtils.safeQueryResultsRelease(templateSrcQry);
        return true;
    }

    private void addCommonAccountPropertyNamesAndValues() throws CMException {
        CMProperty[] props = AccountProxy.getAccountPropertiesToQueryForProxy();
        if (!this.fetchTenantAccountProfileProperties(props, this.tenantName)) {
            this.fetchTenantAccountProfileProperties(props, "");
        }
    }

    private void getPropValuesFromQueryResult(CMProperty[] props, CMStoreQueryResults queryResult) throws CMException {
        for (int i = 0; i < props.length; ++i) {
            Object value = queryResult.getValue(i);
            if (props[i] == CMProperty.POLICIES) {
                CMException cmex;
                try {
                    value = AccMan.createUserAccountPolicyFromTemplate(this.getCamID(), (byte[])value, this.isAnonymousCamID());
                }
                catch (AAAException ex) {
                    cmex = new CMException((Exception)((Object)ex), "cmErrAddUserPolicy");
                    CMIndications.logException(cmex);
                }
                catch (Exception ex) {
                    cmex = new CMException(ex, "cmErrAddUserPolicy");
                    CMIndications.logException(cmex);
                }
            }
            if (value == null) continue;
            this.addPropertyNameValuePair(props[i], value);
        }
    }

    protected boolean isAnonymousCamID() {
        return false;
    }

    private String getDefaultNameOfSecurityObject(String currentUserSearchPath) {
        String defaultName = null;
        if (CMCAMIDHelper.CAMIDFromSearchPath(currentUserSearchPath).equals(this.getCamID())) {
            defaultName = CMExecutionContext.get().getCurrentUserDisplayName();
        } else {
            try {
                CMAAAObjectPropertiesDoc aaaDoc = new CMAAAObjectPropertiesDoc(CMObjectClass.ACCOUNT, this.getCamID(), new CMProperty[]{CMProperty.DEFAULTNAME});
                Object defaultNameValue = aaaDoc.getValue(0);
                if (defaultNameValue != null) {
                    defaultName = defaultNameValue.toString();
                }
            }
            catch (CMException cmEx) {
                CMIndications.logException(cmEx);
            }
        }
        return defaultName;
    }

    private String getUserName() {
        try {
            CMAAAObjectPropertiesDoc aaaDoc = new CMAAAObjectPropertiesDoc(CMObjectClass.ACCOUNT, this.getCamID(), new CMProperty[]{CMProperty.USERNAME});
            Object value = aaaDoc.getValue(0);
            if (value != null) {
                return value.toString();
            }
        }
        catch (CMException cmEx) {
            CMIndications.logException(cmEx);
        }
        return null;
    }

    private static synchronized CMProperty[] getAccountPropertiesToQueryForProxy() {
        if (null == accountPropertiesToQueryForProxy) {
            AccountProxy.determineAccountPropertiesToQueryForProxy();
        }
        return accountPropertiesToQueryForProxy;
    }

    private static void determineAccountPropertiesToQueryForProxy() {
        ArrayList<CMProperty> accountPropertiesList = new ArrayList<CMProperty>();
        for (CMProperty property : CMObjectClass.ACCOUNT.getProperties()) {
            if (!AccountProxy.isApplicableProperty(property)) continue;
            accountPropertiesList.add(property);
        }
        accountPropertiesToQueryForProxy = new CMProperty[accountPropertiesList.size()];
        accountPropertiesList.toArray(accountPropertiesToQueryForProxy);
    }

    private static boolean isApplicableProperty(CMProperty property) {
        return property != CMProperty.OBJECTCLASS && !property.hasMeaning(CMPropertyMeaning.DATA) && property != CMProperty.OBJECTCLASS && property != CMProperty.NAME && property != CMProperty.OWNER && property != CMProperty.ID && property != CMProperty.PARAMETERS && property != CMProperty.TENANTID && property.isUpdateable() && !property.isDefaultMultilingualProperty();
    }

    static synchronized CMProperty getAccountUsernameProperty() {
        if (null == accountUsernameProperty) {
            AccountProxy.determineAccountUsernameProperty();
        }
        return accountUsernameProperty;
    }

    private static void determineAccountUsernameProperty() {
        accountUsernameProperty = CMObjectClass.ACCOUNT.getProperty("userName");
    }
}

