/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.securityproxy;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import java.util.ArrayList;
import java.util.List;

public abstract class SecurityProxy {
    private final String camID;
    private final CMObjectClass objectClass;
    private final int parentObjectID;
    private List<CMProperty> propertyNames;
    private List<Object> propertyValues;

    protected SecurityProxy(String camIDValue, CMObjectClass objectClassValue, int parentIDValue) {
        this.camID = camIDValue;
        this.objectClass = objectClassValue;
        this.parentObjectID = parentIDValue;
        this.propertyNames = new ArrayList<CMProperty>();
        this.propertyValues = new ArrayList<Object>();
    }

    protected String getCamID() {
        return this.camID;
    }

    protected CMObjectClass getObjectClass() {
        return this.objectClass;
    }

    protected List<CMProperty> getPropertyNamesList() {
        return this.propertyNames;
    }

    protected List<Object> getPropertyValuesList() {
        return this.propertyValues;
    }

    protected int getParentObjectID() {
        return this.parentObjectID;
    }

    protected String getName() {
        return this.getCamID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createInStore(CMStore store) throws CMException {
        this.initializePropertyNameAndValueLists();
        boolean useTransactions = !store.inTransaction();
        try {
            if (useTransactions) {
                store.beginTransaction();
            }
            CMStoreQueryResults createResults = ((CMDbStore)store).createObject(this.parentObjectID, -1, new CMDbStoreString(this.getName()), this.getObjectClass(), this.getPropertyNamesList(), this.getPropertyValuesList(), false);
            while (createResults.next()) {
                if (!CMIndicationGlobals.bDebugLogEnabled) continue;
                CMIndications.CMDebugTrace("\tproxy created: (parentId=" + this.getParentObjectID() + ") " + createResults.getSearchPath());
            }
            createResults.release();
            if (useTransactions) {
                store.commitTransaction();
            }
        }
        finally {
            if (useTransactions && store.inTransaction()) {
                try {
                    store.rollbackTransaction();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void initializePropertyNameAndValueLists() throws CMException {
        this.addPropertyNameValuePair(CMProperty.ID, this.getCamID());
        this.addPropertyNameValuePair(CMProperty.OWNER, null);
    }

    protected void addPropertyNameValuePair(CMProperty propertyName, Object propertyValue) {
        this.getPropertyNamesList().add(propertyName);
        this.getPropertyValuesList().add(propertyValue);
    }
}

