/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMXMLUtils;

public class CMDbStoreBooleanSerializer
implements CMDbStoreDataSerializer {
    @Override
    public Object serialize(Object input) throws CMException {
        if (input == null || input.getClass() == Boolean.class) {
            return input;
        }
        String value = input.toString();
        if (value.length() == 0) {
            return null;
        }
        try {
            return CMXMLUtils.parseBooleanAttribute(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (CMException cMException) {
            return Boolean.FALSE;
        }
    }

    @Override
    public Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        return new CMDbStoreString(CMXMLUtils.getBooleanXMLValue((Boolean)input));
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || input.getClass() == String.class && ((String)input).trim().length() == 0;
    }
}

