/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreDeploymentReferenceArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMNamedReference;
import com.cognos.cm.server.CMException;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;

public class CMDbStoreDeploymentReferenceArraySerializer
implements CMDbStoreDataSerializer {
    public CMDbStoreDeploymentReferenceArraySerializer(CMDbProperty property) {
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        CMDbStoreDeploymentReferenceArray deploymentReferences = (CMDbStoreDeploymentReferenceArray)input;
        if (deploymentReferences == null || deploymentReferences.getSize() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int refCnt = deploymentReferences.getSize();
        buffer.append(refCnt);
        buffer.append(";");
        for (int refIdx = 0; refIdx != refCnt; ++refIdx) {
            CMNamedReference deplReference = (CMNamedReference)deploymentReferences.getItem(refIdx);
            CMDbStoreLocalizedStringArray names = (CMDbStoreLocalizedStringArray)deplReference.getName();
            CMDbStoreBaseClassArray objects = (CMDbStoreBaseClassArray)deplReference.getObjects();
            int nameCnt = 0;
            if (names != null) {
                nameCnt = names.getSize();
            }
            buffer.append(nameCnt);
            buffer.append(";");
            int objectCnt = 0;
            if (objects != null) {
                objectCnt = objects.getSize();
            }
            buffer.append(objectCnt);
            buffer.append(";");
            for (int nameIdx = 0; nameIdx != nameCnt; ++nameIdx) {
                CMDbStoreLocalizedString name = (CMDbStoreLocalizedString)names.getItem(nameIdx);
                buffer.append(name.getLocale().getLocaleID());
                buffer.append(";");
                String nameValue = name.getValue();
                buffer.append(nameValue.length());
                buffer.append(";");
                buffer.append(nameValue);
            }
        }
        return buffer.toString();
    }

    @Override
    public final Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        String value = null;
        if (input instanceof Reader) {
            try {
                value = CMStreamUtils.readReaderIntoString((Reader)((Reader)input));
            }
            catch (IOException iOException) {}
        } else {
            value = input.toString();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        int semiPos = value.indexOf(";");
        if (semiPos > 0) {
            int refCount = Integer.parseInt(value.substring(0, semiPos));
            int lastPos = semiPos + 1;
            CMDbStoreDeploymentReferenceArray deploymentReferences = null;
            if (refCount > 0) {
                deploymentReferences = new CMDbStoreDeploymentReferenceArray();
            }
            for (int refIdx = 0; refIdx != refCount; ++refIdx) {
                semiPos = value.indexOf(";", lastPos);
                if (semiPos < 0) {
                    return null;
                }
                int nameCount = Integer.parseInt(value.substring(lastPos, semiPos));
                lastPos = semiPos + 1;
                CMDbStoreLocalizedStringArray name = null;
                if (nameCount > 0) {
                    name = new CMDbStoreLocalizedStringArray();
                }
                if ((semiPos = value.indexOf(";", lastPos)) < 0) {
                    return null;
                }
                int objectCount = Integer.parseInt(value.substring(lastPos, semiPos));
                lastPos = semiPos + 1;
                CMDbStoreBaseClassArray objects = null;
                if (objectCount > 0) {
                    objects = new CMDbStoreBaseClassArray();
                }
                for (int nameIdx = 0; nameIdx != nameCount; ++nameIdx) {
                    semiPos = value.indexOf(";", lastPos);
                    if (semiPos < 0) {
                        return null;
                    }
                    String localeID = value.substring(lastPos, semiPos);
                    lastPos = semiPos + 1;
                    if ((semiPos = value.indexOf(";", lastPos)) < 0) {
                        return null;
                    }
                    int strLen = Integer.parseInt(value.substring(lastPos, semiPos));
                    lastPos = semiPos + 1;
                    String strValue = value.substring(lastPos, lastPos + strLen);
                    lastPos += strLen;
                    CMDbStoreLocalizedString lStr = new CMDbStoreLocalizedString(new CMDbStoreStringLocale(0, 0, localeID), strValue);
                    name.add(lStr);
                }
                for (int objIdx = 0; objIdx != objectCount; ++objIdx) {
                    objects.add(null);
                }
                deploymentReferences.add(new CMNamedReference(name, objects));
            }
            return deploymentReferences;
        }
        return null;
    }

    @Override
    public boolean lobIsNull(Object input) {
        CMDbStoreDeploymentReferenceArray deploymentReferences = (CMDbStoreDeploymentReferenceArray)input;
        return deploymentReferences == null || deploymentReferences.getSize() == 0;
    }
}

