/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.locking.CMLockManager;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.server.CMException;
import java.util.ArrayList;

public class CMDbStoreIDBasedBaseClassArraySingletonSerializer
implements CMDbStoreDataSerializer {
    static final Integer serializeEntry(CMDbStoreObjectReference reference) {
        int objectID = reference.getObjectID();
        if (objectID == -1) {
            throw new IllegalStateException("Invalid data passed to CMDbStoreIDBasedBaseClassArraySingletonSerializer.serialize: unresolved reference");
        }
        return new Integer(objectID);
    }

    public static final CMObjectReference postDeserializeEntry(int objectID, CMObjectClass objectClass, String searchPath, String storeID, String securityReference) {
        CMDbStoreObjectReference ref = null;
        if (objectID != -1) {
            if (objectClass == null || objectClass == CMObjectClass._DELETEDOBJECT) {
                return null;
            }
            ref = securityReference != null ? new CMDbStoreObjectReference(objectID, objectClass, searchPath, false, false) : new CMDbStoreObjectReference(objectID, objectClass, searchPath, securityReference);
            if (storeID != null) {
                ref.setStoreID(storeID);
            }
        }
        return ref;
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        if (input == null) {
            throw new IllegalStateException("Invalid reference passed to CMDbStoreIDBasedBaseClassArraySingletonSerializer.serialize: null");
        }
        if (input.getClass() == Integer.class) {
            return input;
        }
        CMDbStoreObjectReference reference = null;
        if (input instanceof CMBaseClassArray) {
            CMBaseClassArray references = (CMBaseClassArray)input;
            if (references.getSize() == 0) {
                throw new IllegalStateException("Invalid reference passed to CMDbStoreIDBasedBaseClassArraySingletonSerializer.serialize: null");
            }
            if (references.getSize() > 1) {
                throw new IllegalStateException("Invalid number of references in the baseClassArray");
            }
            reference = (CMDbStoreObjectReference)references.getReference(0);
            if (reference == null) {
                throw new IllegalStateException("Invalid reference passed to CMDbStoreIDBasedBaseClassArraySingletonSerializer.serialize: null");
            }
        } else if (input instanceof CMObjectReference) {
            reference = (CMDbStoreObjectReference)input;
        } else {
            throw new IllegalStateException("Invalid data type passed to CMDbStoreIDBasedBaseClassArraySingletonSerializer.serialize:" + input.getClass().getName());
        }
        return CMDbStoreIDBasedBaseClassArraySingletonSerializer.serializeEntry(reference);
    }

    @Override
    public final Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        int objectID = (Integer)input;
        CMObjectReference ref = null;
        try {
            String searchPath = null;
            String storeID = null;
            CMObjectClass objectClass = null;
            String securityReference = null;
            int[] properties = new int[]{4, 1, 2, 3};
            try {
                Object[] values = CMLockManager.getObjectCachedPropertiesInsideLockMutex(objectID, properties);
                if (values == null) {
                    return null;
                }
                objectClass = (CMObjectClass)values[0];
                searchPath = (String)values[1];
                storeID = (String)values[2];
                securityReference = (String)values[3];
            }
            catch (Exception ex) {
                objectID = -1;
            }
            ref = CMDbStoreIDBasedBaseClassArraySingletonSerializer.postDeserializeEntry(objectID, objectClass, searchPath, storeID, securityReference);
        }
        catch (Exception searchPath) {
            // empty catch block
        }
        if (ref == null) {
            return null;
        }
        CMDbStoreBaseClassArray array = new CMDbStoreBaseClassArray();
        array.add(ref);
        return array;
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || input.getClass() == ArrayList.class && ((ArrayList)input).size() == 0 || input instanceof CMBaseClassArray && ((CMBaseClassArray)input).getSize() == 0;
    }
}

