/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.server.CMException;

public class CMDbStoreIntegerSerializer
implements CMDbStoreDataSerializer {
    Integer minValue_;
    Integer maxValue_;
    boolean minExclusive_;
    boolean maxExclusive_;
    private String propName;

    public CMDbStoreIntegerSerializer() {
    }

    public CMDbStoreIntegerSerializer(Integer minValue, Integer maxValue, boolean minExclusive, boolean maxExclusive, String propertyName) {
        this.minValue_ = minValue;
        this.maxValue_ = maxValue;
        this.minExclusive_ = minExclusive;
        this.maxExclusive_ = maxExclusive;
        this.propName = propertyName;
    }

    @Override
    public Object serialize(Object input) throws CMException {
        if (input == null) {
            return null;
        }
        Integer result = null;
        try {
            result = new Integer(input.toString());
            if (this.minValue_ != null && (result < this.minValue_ || this.minExclusive_ && result.intValue() == this.minValue_.intValue())) {
                throw new CMException(this.minExclusive_ ? "cmLTMinimumExclusive" : "cmLTMinimum", new CMException.Parm("Name", this.propName), new CMException.Parm("Value", result.toString()), new CMException.Parm("Limit", this.minValue_.toString()));
            }
            if (this.maxValue_ != null && (result > this.maxValue_ || this.maxExclusive_ && result.intValue() == this.maxValue_.intValue())) {
                throw new CMException(this.maxExclusive_ ? "cmGTMaximumExclusive" : "cmGTMaximum", new CMException.Parm("Name", this.propName), new CMException.Parm("Value", result.toString()), new CMException.Parm("Limit", this.maxValue_.toString()));
            }
        }
        catch (NumberFormatException e) {
            throw new CMException("cmBadInteger", new CMException.Parm("Value", input.toString()));
        }
        return result;
    }

    @Override
    public Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        return new CMDbStoreString(input.toString());
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null;
    }
}

