/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreNavigationPathArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocale;
import com.cognos.cm.dbstore.properties.CMNamedReference;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.server.CMException;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;

public class CMDbStoreNavigationPathArraySerializer
implements CMDbStoreDataSerializer {
    private CMDbProperty property_;

    public CMDbStoreNavigationPathArraySerializer(CMDbProperty property) {
        this.property_ = property;
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        CMDbStoreNavigationPathArray paths = (CMDbStoreNavigationPathArray)input;
        if (paths == null || paths.getSize() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int pathCnt = paths.getSize();
        buffer.append(pathCnt);
        buffer.append(";");
        for (int pathIdx = 0; pathIdx != pathCnt; ++pathIdx) {
            CMNamedReference path = (CMNamedReference)paths.getItem(pathIdx);
            CMDbStoreLocalizedStringArray names = (CMDbStoreLocalizedStringArray)path.getName();
            int nameCnt = names.getSize();
            buffer.append(nameCnt);
            buffer.append(";");
            for (int nameIdx = 0; nameIdx != nameCnt; ++nameIdx) {
                CMDbStoreLocalizedString name = (CMDbStoreLocalizedString)names.getItem(nameIdx);
                buffer.append(name.getLocale().getLocaleID());
                buffer.append(";");
                String nameValue = name.getValue();
                buffer.append(nameValue.length());
                buffer.append(";");
                buffer.append(nameValue);
            }
            CMDbStoreBaseClassArray target = (CMDbStoreBaseClassArray)path.getObjects();
            String targetPath = null;
            if (target != null && target.getSize() > 0 && target.getItem(0) != null) {
                CMObjectReference targetReference = target.getReference(0);
                targetPath = targetReference.getSearchPath();
            }
            if (this.property_ == null || this.property_.hasSubproperties()) continue;
            buffer.append(targetPath == null ? 0 : targetPath.length());
            buffer.append(";");
            if (targetPath == null) continue;
            buffer.append(targetPath);
        }
        return buffer.toString();
    }

    @Override
    public final Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        String value = null;
        if (input instanceof Reader) {
            try {
                value = CMStreamUtils.readReaderIntoString((Reader)((Reader)input));
            }
            catch (IOException iOException) {}
        } else {
            value = input.toString();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        int semiPos = value.indexOf(";");
        if (semiPos > 0) {
            int pathCount = Integer.parseInt(value.substring(0, semiPos));
            int lastPos = semiPos + 1;
            CMDbStoreNavigationPathArray paths = null;
            if (pathCount > 0) {
                paths = new CMDbStoreNavigationPathArray();
            }
            for (int pathIdx = 0; pathIdx != pathCount; ++pathIdx) {
                semiPos = value.indexOf(";", lastPos);
                int nameCount = 0;
                if (semiPos < 0) {
                    return null;
                }
                nameCount = Integer.parseInt(value.substring(lastPos, semiPos));
                lastPos = semiPos + 1;
                CMDbStoreLocalizedStringArray name = null;
                if (nameCount > 0) {
                    name = new CMDbStoreLocalizedStringArray();
                }
                for (int nameIdx = 0; nameIdx != nameCount; ++nameIdx) {
                    semiPos = value.indexOf(";", lastPos);
                    if (semiPos < 0) {
                        return null;
                    }
                    String localeID = value.substring(lastPos, semiPos);
                    lastPos = semiPos + 1;
                    if ((semiPos = value.indexOf(";", lastPos)) < 0) {
                        return null;
                    }
                    int strLen = Integer.parseInt(value.substring(lastPos, semiPos));
                    lastPos = semiPos + 1;
                    String strValue = value.substring(lastPos, lastPos + strLen);
                    lastPos += strLen;
                    CMDbStoreLocalizedString lStr = new CMDbStoreLocalizedString(new CMDbStoreStringLocale(0, 0, localeID), strValue);
                    name.add(lStr);
                }
                CMDbStoreBaseClassArray target = null;
                if (this.property_ != null && !this.property_.hasSubproperties()) {
                    semiPos = value.indexOf(";", lastPos);
                    if (semiPos < 0) {
                        return null;
                    }
                    int targetLen = Integer.parseInt(value.substring(lastPos, semiPos));
                    lastPos = semiPos + 1;
                    if (targetLen > 0) {
                        target = new CMDbStoreBaseClassArray();
                        target.add(new CMDbStoreObjectReference(value.substring(lastPos, lastPos + targetLen)));
                        lastPos += targetLen;
                    }
                }
                paths.add(new CMNamedReference(name, target));
            }
            return paths;
        }
        return null;
    }

    @Override
    public boolean lobIsNull(Object input) {
        CMDbStoreNavigationPathArray paths = (CMDbStoreNavigationPathArray)input;
        return paths == null || paths.getSize() == 0;
    }
}

