/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.server.CMException;

public class CMDbStoreOldTypedNameValuePairSerializer
implements CMDbStoreDataSerializer {
    private CMDbProperty property_;

    public CMDbStoreOldTypedNameValuePairSerializer(CMDbProperty prop) {
        this.property_ = prop;
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        CMTypedNameValuePair value = (CMTypedNameValuePair)input;
        String datum = value.getName();
        String type = value.getTypeName();
        if (datum == null || type == null) {
            throw new IllegalStateException("Name and type cannot be null for TypedNameValuePair");
        }
        short nameID = this.property_.getNameEnumID(datum);
        if (nameID == -1) {
            throw new CMException("cmBadPropValue", new CMException.Parm("Value", datum));
        }
        short typeID = this.property_.getTypeEnumID(type);
        if (typeID == -1) {
            throw new CMException("cmBadPropValue", new CMException.Parm("Value", type));
        }
        return new Object[]{new Short(nameID), value.getValue(), new Short(typeID)};
    }

    @Override
    public final Object deserialize(Object input) {
        Object[] data = (Object[])input;
        short nameID = (Short)data[0];
        short typeID = (Short)data[2];
        String optionValue = (String)data[1];
        String optionName = this.property_.getNameEnumString(nameID);
        String typeName = this.property_.getTypeEnumString(typeID);
        return new CMDbStoreTypedNameValuePair(optionName, optionValue, typeName);
    }

    @Override
    public boolean lobIsNull(Object input) {
        CMTypedNameValuePair value = (CMTypedNameValuePair)input;
        return value.getValue().length() == 0;
    }
}

