/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreRepositoryRule;
import com.cognos.cm.dbstore.properties.CMDbStoreRepositoryRuleArray;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Scanner;

public class CMDbStoreRepositoryRuleSerializer
implements CMDbStoreDataSerializer {
    @Override
    public Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        String value = null;
        if (input instanceof Reader) {
            try {
                value = CMStreamUtils.readReaderIntoString((Reader)((Reader)input));
            }
            catch (IOException iOException) {}
        } else {
            value = input.toString();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        CMDbStoreRepositoryRuleArray rules = new CMDbStoreRepositoryRuleArray();
        int curPos = 0;
        int nlPos = value.indexOf("\n", curPos);
        while (nlPos >= 0) {
            int lineLen = Integer.parseInt(value.substring(curPos, nlPos++));
            curPos = nlPos + lineLen;
            String line = value.substring(nlPos, curPos);
            Scanner lineScanner = new Scanner(line).useDelimiter(",");
            String className = null;
            String dataSourceName = null;
            if (!lineScanner.hasNext()) continue;
            className = lineScanner.next();
            if (!lineScanner.hasNext()) continue;
            dataSourceName = lineScanner.next();
            try {
                CMStore store = CMExecutionContext.get().getStore();
                CMObjectClass objectClass = store.getObjectClasses().getClassByName(className);
                CMDbStoreRepositoryRule rule = new CMDbStoreRepositoryRule(objectClass, dataSourceName);
                rules.add(rule);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nlPos = value.indexOf("\n", curPos);
        }
        return rules;
    }

    @Override
    public Object serialize(Object input) throws CMException {
        CMDbStoreRepositoryRuleArray rules = (CMDbStoreRepositoryRuleArray)input;
        if (rules == null || rules.getSize() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(1024);
        StringBuffer line = new StringBuffer(1024);
        for (int ruleIdx = 0; ruleIdx != rules.getSize(); ++ruleIdx) {
            CMDbStoreRepositoryRule rule = (CMDbStoreRepositoryRule)rules.getRule(ruleIdx);
            line.append(rule.getObjectClass().getName());
            line.append(",");
            line.append(rule.getDataSourceName());
            line.append(",");
            buffer.append(line.length());
            buffer.append("\n");
            buffer.append(line.toString());
            line.setLength(0);
        }
        return buffer.toString();
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || ((CMArrayPropertyValue)input).getSize() == 0;
    }
}

