/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStore;
import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.dbstore.CMDbStoreSecurityUtil;
import com.cognos.cm.dbstore.properties.CMDbStoreBaseClassArray;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMQueryUtils;
import java.util.ArrayList;

public class CMDbStoreResolvedBaseClassArraySingletonSerializer
implements CMDbStoreDataSerializer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Integer serializeSecurityEntry(String refSearchPath, StringBuffer normalizedSearchPath) {
        int objectID = -1;
        CMStoreQueryResults results = null;
        try {
            CMStoreXPath path = new CMStoreXPath(refSearchPath);
            String camID = CMDbStoreSecurityUtil.getCAMID(path.stepAt(0));
            CMDbStore store = (CMDbStore)CMExecutionContext.get().getStore();
            if (camID != null) {
                if (camID.charAt(0) == ':') {
                    results = CMExecutionContext.get().getStore().executeQuery(path, null, null, 0, 512, null);
                    if (results.next()) {
                        if (results.getObjectClass() == CMObjectClass.ACCOUNT || results.getObjectClass() == CMObjectClass.GROUP || results.getObjectClass() == CMObjectClass.ROLE) {
                            objectID = results.getObjectID();
                        }
                        if (normalizedSearchPath != null) {
                            normalizedSearchPath.append(results.getSecurityReference());
                        }
                    }
                } else {
                    objectID = store.createSecurityProxyObject(camID, null, null);
                    if (objectID != -1 && normalizedSearchPath != null) {
                        normalizedSearchPath.append(store.getCache().CMCacheGetSecurityReference(objectID));
                    }
                }
            }
        }
        catch (Exception ex) {
            objectID = -1;
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(results);
        }
        if (objectID == -1) {
            return null;
        }
        return new Integer(objectID);
    }

    static final Integer serializeEntry(CMDbStoreObjectReference reference, StringBuffer normalizedPath) {
        int objectID = reference.getObjectID();
        if (reference.isSecurityReference() && !reference.isResolved()) {
            return CMDbStoreResolvedBaseClassArraySingletonSerializer.serializeSecurityEntry(reference.toString(), normalizedPath);
        }
        if (objectID == -1) {
            return null;
        }
        return new Integer(objectID);
    }

    static final CMObjectReference deserializeEntry(int objectID) {
        String searchPath = null;
        CMObjectClass objectClass = null;
        String securityReference = null;
        try {
            CMCache cache = ((CMDbStore)CMExecutionContext.get().getStore()).getCache();
            int classID = cache.CMCacheGetClass(objectID);
            objectClass = CMDbStoreFactory.objectClasses_.getClassByID(classID);
            if (objectClass == CMObjectClass._DELETEDOBJECT) {
                return null;
            }
            searchPath = cache.CMCacheGetSearchPath(objectID, CMDbStoreCacheUtil.getCacheSearchLocales());
            securityReference = cache.CMCacheGetSecurityReference(objectID);
        }
        catch (Exception ex) {
            objectID = -1;
        }
        if (objectID != -1) {
            if (securityReference != null) {
                return new CMDbStoreObjectReference(objectID, objectClass, searchPath, false, false);
            }
            return new CMDbStoreObjectReference(objectID, objectClass, searchPath, securityReference);
        }
        return null;
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        if (input == null || input.getClass() == Integer.class) {
            return input;
        }
        CMDbStoreObjectReference reference = null;
        if (input instanceof CMBaseClassArray) {
            CMBaseClassArray references = (CMBaseClassArray)input;
            if (references.getSize() == 0) {
                return null;
            }
            if (references.getSize() > 1) {
                throw new IllegalStateException("Invalid number of references in the baseClassArray");
            }
            reference = (CMDbStoreObjectReference)references.getReference(0);
        } else if (input instanceof CMObjectReference) {
            reference = (CMDbStoreObjectReference)input;
        } else {
            throw new IllegalStateException("Invalid data type passed to CMDbStoreResolvedBaseClassArraySingletonSerializer.serialize:" + input.getClass().getName());
        }
        return CMDbStoreResolvedBaseClassArraySingletonSerializer.serializeEntry(reference, null);
    }

    @Override
    public final Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        int objectID = (Integer)input;
        CMObjectReference ref = CMDbStoreResolvedBaseClassArraySingletonSerializer.deserializeEntry(objectID);
        if (ref != null) {
            CMDbStoreBaseClassArray array = new CMDbStoreBaseClassArray();
            array.add(ref);
            return array;
        }
        return null;
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || input.getClass() == ArrayList.class && ((ArrayList)input).size() == 0 || input instanceof CMBaseClassArray && ((CMBaseClassArray)input).getSize() == 0;
    }
}

