/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreRetentionRule;
import com.cognos.cm.dbstore.properties.CMDbStoreRetentionRuleArray;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class CMDbStoreRetentionRuleSerializer
implements CMDbStoreDataSerializer {
    @Override
    public Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        String value = null;
        if (input instanceof Reader) {
            try {
                value = CMStreamUtils.readReaderIntoString((Reader)((Reader)input));
            }
            catch (IOException iOException) {}
        } else {
            value = input.toString();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        CMDbStoreRetentionRuleArray rules = new CMDbStoreRetentionRuleArray();
        int curPos = 0;
        int nlPos = value.indexOf("\n", curPos);
        while (nlPos >= 0) {
            int lineLen = Integer.parseInt(value.substring(curPos, nlPos++));
            curPos = nlPos + lineLen;
            String line = value.substring(nlPos, curPos);
            StringTokenizer lineToker = new StringTokenizer(line, ",");
            String className = null;
            String propName = null;
            String maxObjsStr = null;
            String maxDur = null;
            if (!lineToker.hasMoreTokens()) continue;
            className = lineToker.nextToken();
            if (!lineToker.hasMoreTokens()) continue;
            propName = lineToker.nextToken();
            if (!lineToker.hasMoreTokens()) continue;
            maxObjsStr = lineToker.nextToken();
            if (lineToker.hasMoreTokens()) {
                maxDur = lineToker.nextToken();
            }
            try {
                CMStore store = CMExecutionContext.get().getStore();
                CMObjectClass objectClass = store.getObjectClasses().getClassByName(className);
                CMDbStoreRetentionRule rule = new CMDbStoreRetentionRule(objectClass, store.getPropertySets().getPropertySetAt(0).getProperty(propName, objectClass), Integer.parseInt(maxObjsStr), maxDur);
                rules.add(rule);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nlPos = value.indexOf("\n", curPos);
        }
        return rules;
    }

    @Override
    public Object serialize(Object input) throws CMException {
        CMDbStoreRetentionRuleArray rules = (CMDbStoreRetentionRuleArray)input;
        int ruleCount = rules.getSize();
        if (ruleCount == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(1024);
        StringBuffer line = new StringBuffer(1024);
        for (int ruleIdx = 0; ruleIdx != ruleCount; ++ruleIdx) {
            CMDbStoreRetentionRule rule = (CMDbStoreRetentionRule)rules.getRule(ruleIdx);
            line.append(rule.getObjectClass().getName());
            line.append(",");
            line.append(rule.getProperty().getName());
            line.append(",");
            line.append(Integer.toString(rule.getMaxObjects()));
            line.append(",");
            String maxDuration = rule.getMaxDuration();
            if (maxDuration != null) {
                line.append(maxDuration);
            }
            buffer.append(line.length());
            buffer.append("\n");
            buffer.append(line.toString());
            line.setLength(0);
        }
        return buffer.toString();
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || ((CMArrayPropertyValue)input).getSize() == 0;
    }
}

