/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.server.CMException;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;

public class CMDbStoreStringArraySerializer
implements CMDbStoreDataSerializer {
    @Override
    public final Object serialize(Object input) throws CMException {
        CMArrayPropertyValue value = (CMArrayPropertyValue)input;
        if (input == null || value.getSize() == 0) {
            return null;
        }
        return CMDbStoreStringArraySerializer.serialize(value);
    }

    @Override
    public final Object deserialize(Object input) {
        if (input == null) {
            return null;
        }
        String value = null;
        if (input instanceof Reader) {
            try {
                value = CMStreamUtils.readReaderIntoString((Reader)((Reader)input));
            }
            catch (IOException iOException) {}
        } else {
            value = input.toString();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        CMDbStoreStringArray arrayValue = new CMDbStoreStringArray();
        CMDbStoreStringArraySerializer.deserialize(value, arrayValue, CMDbStoreString.class);
        return arrayValue;
    }

    static String serialize(CMArrayPropertyValue arrayValue) {
        StringBuffer buffer = new StringBuffer(1024);
        for (int i = 0; i < arrayValue.getSize(); ++i) {
            String elementStr = arrayValue.getItem(i).toString();
            buffer.append(Integer.toString(elementStr.length()));
            buffer.append('\n');
            buffer.append(elementStr);
        }
        return buffer.toString();
    }

    static void deserialize(String value, CMArrayPropertyValue arrayValue, Class entryClass) {
        int index = value.indexOf(10);
        int curPos = 0;
        try {
            Constructor constructor = entryClass.getConstructor(String.class);
            while (index >= 0) {
                int len = Integer.parseInt(value.substring(curPos, index));
                curPos = index + 1 + len;
                arrayValue.add(constructor.newInstance(value.substring(index + 1, curPos)));
                index = value.indexOf(10, curPos);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Invalid class passed as entry instance factory: " + entryClass.getName());
        }
    }

    @Override
    public boolean lobIsNull(Object input) {
        CMArrayPropertyValue value = (CMArrayPropertyValue)input;
        return input == null || value.getSize() == 0;
    }
}

