/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreArrayXMLValue;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMInputStreamWithSize;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class CMDbStoreStringCompressingSerializer
implements CMDbStoreDataSerializer {
    @Override
    public Object serialize(Object input) throws CMException {
        if (input == null) {
            return null;
        }
        if (input.getClass() == String.class || input.getClass() == CMDbStoreArrayXMLValue.class) {
            String value = null;
            if (input.getClass() == String.class) {
                value = input.toString();
            } else if (input.getClass() == CMDbStoreArrayXMLValue.class) {
                value = ((CMDbStoreArrayXMLValue)input).getAllXMLContent();
            }
            if (value.length() == 0) {
                return null;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                GZIPOutputStream os = new GZIPOutputStream((OutputStream)baos, 32768);
                CMStreamUtils.copyStream((InputStream)new ByteArrayInputStream(CMStringUtils.getUTF8BytesFromString(value)), (OutputStream)os);
                ((OutputStream)os).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return baos.toByteArray();
        }
        if (input instanceof CMInputStreamWithSize) {
            return input;
        }
        throw new IllegalStateException("CMDbStoreStringCompressingSerializer.serialize, data is unsupported type: " + input.getClass().getName());
    }

    @Override
    public Object deserialize(Object input) {
        return input;
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || input.getClass() == String.class && input.toString().length() == 0;
    }
}

