/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.dbstore.serializers;

import com.cognos.cm.dbstore.CMDbProperty;
import com.cognos.cm.dbstore.CMDbStoreDataSerializer;
import com.cognos.cm.dbstore.properties.CMDbStoreStringNameValuePair;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMStringNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePair;
import com.cognos.cm.properties.CMTypedNameValuePairArray;
import com.cognos.cm.server.CMException;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.IOException;
import java.io.Reader;

public class CMDbStoreStringNameValuePairArraySerializer
implements CMDbStoreDataSerializer {
    public CMDbStoreStringNameValuePairArraySerializer(CMDbProperty prop) {
    }

    @Override
    public final Object serialize(Object input) throws CMException {
        CMTypedNameValuePairArray array = (CMTypedNameValuePairArray)input;
        if (array == null || array.getSize() == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(1024);
        int itemCount = array.getSize();
        for (int itemIdx = 0; itemIdx != itemCount; ++itemIdx) {
            CMTypedNameValuePair nvPair = array.getPair(itemIdx);
            if (!(nvPair instanceof CMStringNameValuePair)) {
                throw new IllegalStateException("Inconsistent pair type. CMStringNameValuePair is expected");
            }
            CMStringNameValuePair snvPair = (CMStringNameValuePair)nvPair;
            String datum = snvPair.getName();
            String nameEnumName = snvPair.getNameEnumName();
            String type = snvPair.getTypeName();
            if (datum == null || type == null || nameEnumName == null) {
                throw new IllegalStateException("Name and type cannot be null for TypedNameValuePair");
            }
            if (datum.length() > 0 && (datum.indexOf(59) >= 0 || datum.charAt(0) == '-')) {
                buffer.append('-');
                buffer.append(datum.length());
                buffer.append(';');
            }
            buffer.append(datum);
            buffer.append(";");
            buffer.append(nameEnumName);
            buffer.append(";");
            buffer.append(type);
            buffer.append(";");
            buffer.append(snvPair.getValue().length());
            buffer.append(";");
            buffer.append(snvPair.getValue());
        }
        return buffer.toString();
    }

    @Override
    public final Object deserialize(Object input) {
        int semicPos;
        if (input == null) {
            return null;
        }
        String value = null;
        if (input instanceof Reader) {
            try {
                value = CMStreamUtils.readReaderIntoString((Reader)((Reader)input));
            }
            catch (IOException iOException) {}
        } else {
            value = input.toString();
        }
        if (value == null || value.length() == 0) {
            return null;
        }
        CMDbStoreTypedNameValuePairArray newArray = new CMDbStoreTypedNameValuePairArray();
        int curPos = 0;
        int dataLength = value.length();
        while (curPos < dataLength && (semicPos = value.indexOf(";", curPos)) >= 0) {
            String name;
            if ((name = value.substring(curPos, semicPos++)).length() > 0 && name.charAt(0) == '-') {
                int nameLen = -Integer.parseInt(name);
                name = value.substring(semicPos, semicPos + nameLen);
                semicPos += nameLen + 1;
            }
            curPos = semicPos;
            if ((semicPos = value.indexOf(";", semicPos)) < 0) break;
            String nameEnumName = value.substring(curPos, semicPos++);
            curPos = semicPos;
            if ((semicPos = value.indexOf(";", semicPos)) < 0) break;
            String typeName = value.substring(curPos, semicPos++);
            curPos = semicPos;
            if ((semicPos = value.indexOf(";", semicPos)) < 0) break;
            int valueLen = Integer.parseInt(value.substring(curPos, semicPos++));
            String dataValue = value.substring(semicPos, semicPos + valueLen);
            curPos = semicPos + valueLen;
            newArray.add(new CMDbStoreStringNameValuePair(name, nameEnumName, dataValue, typeName));
        }
        if (newArray.getSize() > 0) {
            return newArray;
        }
        return null;
    }

    @Override
    public boolean lobIsNull(Object input) {
        return input == null || ((CMArrayPropertyValue)input).getSize() == 0;
    }
}

